/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.config;

import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class TLBClientConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder().comment("ToLaserBlade's client side settings.").push("client");
    private static final ModConfigSpec.BooleanValue SHOW_UPDATE_MESSAGE = BUILDER.comment("Enable to show update message.").translation("tolaserblade.configgui.client.showUpdateMessage").define("showUpdateMessage", true);
    private static final ModConfigSpec.BooleanValue USE_ORIGINAL_MODEL_TYPE = BUILDER.comment("Using mod model loader to load Laser Blade models.\nSet to false to use the model that loaded by vanilla model loader.\nNeed to reload resource packs after changing this.").translation("tolaserblade.configgui.client.useOriginalModelType").define("useOriginalModelType", true);
    private static final ModConfigSpec.BooleanValue RENDER_MULTIPLE_MODELS = BUILDER.comment("Enable to render Laser Blades using multiple models. Set to false to use the model of defaultModelType.\nThis setting is valid when useOriginalModelLoader is true.\nNeed to reload resource packs after changing this.").translation("tolaserblade.configgui.client.renderMultipleModels").define("renderMultipleModels", true);
    private static final ModConfigSpec.IntValue DEFAULT_MODEL = BUILDER.comment("A non-negative integer representing the model number of laser blades to use when renderMultipleModels is false.\nThis setting is valid when useOriginalModelType is true.\nNeed to reload resource packs after changing this.").translation("tolaserblade.configgui.client.defaultModel").defineInRange("defaultModel", 0, 0, Integer.MAX_VALUE);
    private static final ModConfigSpec.BooleanValue USE_SHIELD_SOUND_FOR_LASER_BLADE = BUILDER.comment("Play the sound event for shields when a laser blade blocks an attack.\nThis setting is valid when playing in a world where enableBlockingWithLaserBlade in tolaserblade-server.toml is true.\nSet to false to play the blocking sound events of this mod.").translation("tolaserblade.configgui.client.useShieldSoundForLaserBlade").define("useShieldSoundForLaserBlade", true);
    public static final ModConfigSpec SPEC = BUILDER.pop().build();
    public static boolean showUpdateMessage = (Boolean)SHOW_UPDATE_MESSAGE.getDefault();
    public static boolean useOriginalModelType = (Boolean)USE_ORIGINAL_MODEL_TYPE.getDefault();
    public static boolean renderMultipleModels = (Boolean)RENDER_MULTIPLE_MODELS.getDefault();
    public static int defaultModel = (Integer)DEFAULT_MODEL.getDefault();
    public static boolean useShieldSoundForLaserBlade = (Boolean)USE_SHIELD_SOUND_FOR_LASER_BLADE.getDefault();

    public static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        showUpdateMessage = (Boolean)SHOW_UPDATE_MESSAGE.get();
        useOriginalModelType = (Boolean)USE_ORIGINAL_MODEL_TYPE.get();
        renderMultipleModels = (Boolean)RENDER_MULTIPLE_MODELS.get();
        defaultModel = (Integer)DEFAULT_MODEL.get();
        useShieldSoundForLaserBlade = (Boolean)USE_SHIELD_SOUND_FOR_LASER_BLADE.get();
    }
}

