/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.config;

import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class TLBServerConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder().comment("ToLaserBlade's game server side settings.").push("server");
    private static final ModConfigSpec.BooleanValue IS_ENABLED_BLOCKING_WITH_LASER_BLADE = BUILDER.comment("Enable blocking with Laser Blade.").translation("tolaserblade.configgui.server.enableBlockingWithLaserBlade").define("enableBlockingWithLaserBlade", false);
    private static final ModConfigSpec.IntValue LASER_BLADE_EFFICIENCY = BUILDER.comment("An integer value (0-128) that is a factor of mining speed of Laser Blade.").translation("tolaserblade.configgui.server.laserBladeEfficiency").defineInRange("laserBladeEfficiency", 12, 0, 128);
    private static final ModConfigSpec.DoubleValue LASER_BLADE_BASE_DAMAGE = BUILDER.comment("A real number value (0.0-2046.0) that is the base attack damage of Laser Blade.").translation("tolaserblade.configgui.server.laserBladeBaseDamage").defineInRange("laserBladeBaseDamage", 6.0, 0.0, 2046.0);
    private static final ModConfigSpec.DoubleValue LASER_BLADE_BASE_SPEED = BUILDER.comment("A real number value (0.8-2.8) that is the base attack speed of Laser Blade.").translation("tolaserblade.configgui.server.laserBladeBaseSpeed").defineInRange("laserBladeBaseSpeed", 2.8, 0.8, 2.8);
    private static final ModConfigSpec.IntValue MAX_ATTACK_DAMAGE_UPGRADE_COUNT = BUILDER.comment("An integer value (0-2047) that is maximum count of attack damage upgrade of Laser Blade.\nNote:\n  Making the advancement [It's Over 9] requires 3 or more.\n  Similarly, [Beyond the Limit] requires 8 or more.").translation("tolaserblade.configgui.server.maxAttackDamageUpgradeCount").defineInRange("maxAttackDamageUpgradeCount", 8, 0, 2047);
    private static final ModConfigSpec.IntValue ATTACK_DAMAGE_UPGRADE_MULTIPLIER = BUILDER.comment("An integer value (1-2048) that is the damage multiplier for attack damage upgrade of Laser Blade.").translation("tolaserblade.configgui.server.attackDamageUpgradeMultiplier").defineInRange("attackDamageUpgradeMultiplier", 1, 1, 2048);
    private static final ModConfigSpec.BooleanValue IS_ENABLED_LASER_TRAP = BUILDER.comment("Enable to attack with Laser Blade in Dispenser when the dispenser is activated.").translation("tolaserblade.configgui.server.enableLaserTrap").define("enableLaserTrap", true);
    private static final ModConfigSpec.BooleanValue CAN_LASER_TRAP_ATTACK_PLAYER = BUILDER.comment("A boolean value represents whether laser trap can attack player or not.\nThis setting is valid when enableLaserTrap is true.").translation("tolaserblade.configgui.server.canLaserTrapAttackPlayer").define("canLaserTrapAttackPlayer", true);
    private static final ModConfigSpec.BooleanValue CAN_LASER_TRAP_HEAT_UP_FURNACE = BUILDER.comment("A boolean value represents whether laser trap with fireproof Laser Blade can heat up furnace or not.\nThis setting is valid when enableLaserTrap is true.").translation("tolaserblade.configgui.server.canLaserTrapHeatUpFurnace").define("canLaserTrapHeatUpFurnace", true);
    public static final ModConfigSpec SPEC = BUILDER.pop().build();
    public static boolean isEnabledBlockingWithLaserBlade = (Boolean)IS_ENABLED_BLOCKING_WITH_LASER_BLADE.getDefault();
    public static int laserBladeEfficiency = (Integer)LASER_BLADE_EFFICIENCY.getDefault();
    public static float laserBladeBaseDamage = TLBServerConfig.calcAttackDamage((Double)LASER_BLADE_BASE_DAMAGE.getDefault());
    public static float laserBladeBaseSpeed = TLBServerConfig.calcAttackSpeed((Double)LASER_BLADE_BASE_SPEED.getDefault());
    public static int maxAttackDamageUpgradeCount = (Integer)MAX_ATTACK_DAMAGE_UPGRADE_COUNT.getDefault();
    public static float attackDamageUpgradeMultiplier = ((Integer)ATTACK_DAMAGE_UPGRADE_MULTIPLIER.getDefault()).floatValue();
    public static boolean isEnabledLaserTrap = (Boolean)IS_ENABLED_LASER_TRAP.getDefault();
    public static boolean canLaserTrapAttackPlayer = (Boolean)CAN_LASER_TRAP_ATTACK_PLAYER.getDefault();
    public static boolean canLaserTrapHeatUpFurnace = (Boolean)CAN_LASER_TRAP_HEAT_UP_FURNACE.getDefault();

    public static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() != SPEC || !SPEC.isLoaded()) {
            return;
        }
        isEnabledBlockingWithLaserBlade = (Boolean)IS_ENABLED_BLOCKING_WITH_LASER_BLADE.get();
        laserBladeEfficiency = (Integer)LASER_BLADE_EFFICIENCY.get();
        laserBladeBaseDamage = TLBServerConfig.calcAttackDamage((Double)LASER_BLADE_BASE_DAMAGE.get());
        laserBladeBaseSpeed = TLBServerConfig.calcAttackSpeed((Double)LASER_BLADE_BASE_SPEED.get());
        maxAttackDamageUpgradeCount = (Integer)MAX_ATTACK_DAMAGE_UPGRADE_COUNT.get();
        attackDamageUpgradeMultiplier = ((Integer)ATTACK_DAMAGE_UPGRADE_MULTIPLIER.get()).floatValue();
        isEnabledLaserTrap = (Boolean)IS_ENABLED_LASER_TRAP.get();
        canLaserTrapAttackPlayer = (Boolean)CAN_LASER_TRAP_ATTACK_PLAYER.get();
        canLaserTrapHeatUpFurnace = (Boolean)CAN_LASER_TRAP_HEAT_UP_FURNACE.get();
    }

    private static float calcAttackDamage(double d) {
        return (float)d - 6.0f;
    }

    private static float calcAttackSpeed(double d) {
        return (float)d - 2.8f;
    }
}

