/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.dispenser;

import com.github.iunius118.tolaserblade.common.util.LaserTrapPlayer;
import com.github.iunius118.tolaserblade.config.TLBServerConfig;
import com.github.iunius118.tolaserblade.mixin.AbstractFurnaceBlockEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DispenseLaserBladeBehavior
implements DispenseItemBehavior {
    public static final DispenseItemBehavior DEFAULT_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior();
    public static final int LASER_BURN_TIME = 200;

    public ItemStack dispense(BlockSource blockSource, ItemStack itemStack) {
        if (!TLBServerConfig.isEnabledLaserTrap) {
            return DEFAULT_ITEM_BEHAVIOR.dispense(blockSource, itemStack);
        }
        ServerLevel serverLevel = blockSource.level();
        BlockPos pos = blockSource.pos();
        Direction dir = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
        BlockEntity targetBlockEntity = serverLevel.getBlockEntity(pos.relative(dir));
        if (TLBServerConfig.canLaserTrapHeatUpFurnace && targetBlockEntity instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)targetBlockEntity;
            this.litFurnace(furnace, itemStack);
        } else {
            LaserTrapPlayer.attackEntities(serverLevel, pos, itemStack, dir);
        }
        return itemStack;
    }

    private void litFurnace(AbstractFurnaceBlockEntity furnace, ItemStack stack) {
        AbstractFurnaceBlockEntityAccessor furnaceAccessor = (AbstractFurnaceBlockEntityAccessor)furnace;
        int litTimeRemaining = furnaceAccessor.getLitTimeRemaining();
        if (litTimeRemaining < 201) {
            boolean isNotLit = litTimeRemaining < 1;
            furnaceAccessor.setLitTimeRemaining(201);
            furnaceAccessor.setLitTotalTime(200);
            furnace.setChanged();
            if (isNotLit) {
                Level level = furnace.getLevel();
                BlockPos pos = furnace.getBlockPos();
                level.setBlock(pos, (BlockState)level.getBlockState(pos).setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.TRUE), 3);
            }
        }
    }
}

