/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade;

import com.github.iunius118.tolaserblade.api.core.laserblade.LaserBladeState;
import com.github.iunius118.tolaserblade.config.TLBServerConfig;
import com.github.iunius118.tolaserblade.core.component.ModDataComponents;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeDataMigrator;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemUtil;
import com.github.iunius118.tolaserblade.world.item.ModToolMaterials;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class LaserBlade {
    public static final float BASE_ATTACK = 3.0f;
    public static final float BASE_SPEED = -1.2f;
    public static final float MOD_ATK_MIN = 0.0f;
    public static final float MOD_ATK_MAX = 4194304.0f;
    public static final float MOD_ATK_GIFT = 3.0f;
    public static final float MOD_ATK_CRITICAL_BONUS = 8.0f;
    public static final float MOD_CRITICAL_BONUS_VS_WITHER = 0.5f;
    public static final float MOD_SPD_MIN = 0.0f;
    public static final float MOD_SPD_MAX = 1.2f;
    public static final int TYPE_DEFAULT = 0;

    private LaserBlade() {
    }

    public static float getAttack(ItemStack itemStack) {
        float attack = Objects.requireNonNullElseGet((Float)itemStack.get(ModDataComponents.LASER_BLADE_ATTACK), () -> Float.valueOf(LaserBladeDataMigrator.getAttack(itemStack))).floatValue();
        return Mth.clamp((float)attack, (float)0.0f, (float)4194304.0f);
    }

    public static float getAttack(ItemStack itemStack, float multiplier) {
        float attack = Objects.requireNonNullElseGet((Float)itemStack.get(ModDataComponents.LASER_BLADE_ATTACK), () -> Float.valueOf(LaserBladeDataMigrator.getAttack(itemStack))).floatValue();
        return Mth.clamp((float)(attack * multiplier), (float)0.0f, (float)4194304.0f);
    }

    public static void setAttack(ItemStack itemStack, float damage) {
        itemStack.set(ModDataComponents.LASER_BLADE_ATTACK, (Object)Float.valueOf(damage));
    }

    public static float getSpeed(ItemStack itemStack) {
        float speed = Objects.requireNonNullElseGet((Float)itemStack.get(ModDataComponents.LASER_BLADE_SPEED), () -> Float.valueOf(LaserBladeDataMigrator.getSpeed(itemStack))).floatValue();
        return Mth.clamp((float)speed, (float)0.0f, (float)1.2f);
    }

    public static void setSpeed(ItemStack itemStack, float speed) {
        itemStack.set(ModDataComponents.LASER_BLADE_SPEED, (Object)Float.valueOf(speed));
    }

    public static boolean canUpgradeAttack(float attack) {
        return attack < LaserBlade.getMaxAttackUpgradeCount();
    }

    private static float getMaxAttackUpgradeCount() {
        return TLBServerConfig.maxAttackDamageUpgradeCount;
    }

    public static boolean canUpgradeSpeed(float speed) {
        return speed < 1.2f;
    }

    public static void updateItemAttributeModifiers(ItemStack itemStack) {
        float damageUpgradeMultiplier = TLBServerConfig.attackDamageUpgradeMultiplier;
        float baseDamage = TLBServerConfig.laserBladeBaseDamage;
        float attackDamage = LaserBlade.getAttack(itemStack, damageUpgradeMultiplier) + baseDamage + 3.0f;
        float attackSpeed = LaserBlade.getSpeed(itemStack) + TLBServerConfig.laserBladeBaseSpeed + -1.2f;
        boolean isFireResistant = LaserBladeItemUtil.isFireResistant(itemStack);
        ItemAttributeModifiers itemAttributeModifiers = LaserBlade.createAttributes(attackDamage += ModToolMaterials.getLBSwordMaterial(isFireResistant).attackDamageBonus(), attackSpeed);
        itemStack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)itemAttributeModifiers);
    }

    private static ItemAttributeModifiers createAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static LaserBladeState getState(ItemStack itemStack) {
        float attack = LaserBlade.getAttack(itemStack);
        float speed = LaserBlade.getSpeed(itemStack);
        LaserBladeAppearance appearance = LaserBladeAppearance.of(itemStack);
        int type = appearance.getType();
        LaserBladeState.Part outer = appearance.getOuter();
        LaserBladeState.Part inner = appearance.getInner();
        LaserBladeState.Part grip = appearance.getGrip();
        return new LaserBladeStateImpl(attack, speed, type, outer, inner, grip);
    }

    public record LaserBladeStateImpl(float attack, float speed, int modelType, LaserBladeState.Part outer, LaserBladeState.Part inner, LaserBladeState.Part grip) implements LaserBladeState
    {
    }
}

