/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade;

import com.github.iunius118.tolaserblade.api.core.laserblade.LaserBladeState;
import com.github.iunius118.tolaserblade.core.component.ModDataComponents;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeColor;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeDataMigrator;
import com.github.iunius118.tolaserblade.world.item.component.LaserBladeModelData;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class LaserBladeAppearance {
    private static final String KEY_OUTER = "out";
    private static final String KEY_INNER = "in";
    private static final String KEY_GRIP = "grip";
    private static final LaserBladeModelData.PartData DEFAULT_OUT = new LaserBladeModelData.PartData(false, LaserBladeColor.RED.getOuterColor(), false);
    private static final LaserBladeModelData.PartData DEFAULT_IN = new LaserBladeModelData.PartData(false, LaserBladeColor.WHITE.getInnerColor(), false);
    private static final LaserBladeModelData.PartData DEFAULT_GRIP = new LaserBladeModelData.PartData(false, LaserBladeColor.WHITE.getGripColor(), false);
    private int type = 0;
    private LaserBladeModelData.PartData out = DEFAULT_OUT;
    private LaserBladeModelData.PartData in = DEFAULT_IN;
    private LaserBladeModelData.PartData grip = DEFAULT_GRIP;

    public LaserBladeAppearance() {
    }

    public LaserBladeAppearance(LaserBladeModelData modelData) {
        this.type = modelData.modelType();
        Map<String, LaserBladeModelData.PartData> parts = modelData.parts();
        this.out = Objects.requireNonNullElse(parts.get(KEY_OUTER), this.out);
        this.in = Objects.requireNonNullElse(parts.get(KEY_INNER), this.in);
        this.grip = Objects.requireNonNullElse(parts.get(KEY_GRIP), this.grip);
    }

    public static LaserBladeAppearance of() {
        return new LaserBladeAppearance();
    }

    public static LaserBladeAppearance of(ItemStack itemStack) {
        LaserBladeModelData modelData = (LaserBladeModelData)itemStack.get(ModDataComponents.LASER_BLADE_MODEL);
        if (modelData != null) {
            return new LaserBladeAppearance(modelData);
        }
        return LaserBladeDataMigrator.getAppearance(itemStack);
    }

    public int getType() {
        return Math.max(this.type, 0);
    }

    public LaserBladeAppearance setType(int type) {
        this.type = type;
        return this;
    }

    public LaserBladeState.Part getOuter() {
        return this.out;
    }

    public int getOuterColor() {
        return this.out.color();
    }

    public boolean isOuterSubColor() {
        return this.out.isSubtractiveColor();
    }

    public LaserBladeAppearance setOuterColor(int outerColor, boolean outerSubColor) {
        this.out = LaserBladeModelData.PartData.create(outerColor, outerSubColor);
        return this;
    }

    public LaserBladeAppearance setOuterColor(int outerColor) {
        return this.setOuterColor(outerColor, this.out.isSubtractiveColor());
    }

    public LaserBladeAppearance setOuterSubColor(boolean outerSubColor) {
        return this.setOuterColor(this.out.color(), outerSubColor);
    }

    public LaserBladeAppearance switchOuterSubColor() {
        return this.setOuterSubColor(!this.out.isSubtractiveColor());
    }

    public LaserBladeState.Part getInner() {
        return this.in;
    }

    public int getInnerColor() {
        return this.in.color();
    }

    public boolean isInnerSubColor() {
        return this.in.isSubtractiveColor();
    }

    public LaserBladeAppearance setInnerColor(int innerColor, boolean innerSubColor) {
        this.in = LaserBladeModelData.PartData.create(innerColor, innerSubColor);
        return this;
    }

    public LaserBladeAppearance setInnerColor(int innerColor) {
        return this.setInnerColor(innerColor, this.in.isSubtractiveColor());
    }

    public LaserBladeAppearance setInnerSubColor(boolean innerSubColor) {
        return this.setInnerColor(this.in.color(), innerSubColor);
    }

    public LaserBladeAppearance switchInnerSubColor() {
        return this.setInnerSubColor(!this.in.isSubtractiveColor());
    }

    public LaserBladeState.Part getGrip() {
        return this.grip;
    }

    public int getGripColor() {
        return this.grip.color();
    }

    public LaserBladeAppearance setGripColor(int gripColor) {
        this.grip = LaserBladeModelData.PartData.create(gripColor, false);
        return this;
    }

    public LaserBladeAppearance setColor(LaserBladeColor color) {
        this.out = LaserBladeModelData.PartData.create(color.getOuterColor(), color.isOuterSubColor());
        this.in = LaserBladeModelData.PartData.create(color.getInnerColor(), color.isInnerSubColor());
        this.grip = LaserBladeModelData.PartData.create(color.getGripColor(), false);
        return this;
    }

    public LaserBladeAppearance setColorsByBiome(Level level, Holder<Biome> biomeHolder) {
        ResourceKey dimension = level.dimension();
        if (Level.NETHER.equals(dimension)) {
            this.setColorsByNetherBiome(level, biomeHolder);
        } else if (Level.END.equals(dimension)) {
            this.setColorsByEndBiome(level, biomeHolder);
        } else {
            this.setColorsByOverWorldBiome(level, biomeHolder);
        }
        return this;
    }

    public void setTo(ItemStack itemStack) {
        ImmutableMap.Builder partBuilder = new ImmutableMap.Builder();
        if (this.out.exists()) {
            partBuilder.put((Object)KEY_OUTER, (Object)this.out);
        }
        if (this.in.exists()) {
            partBuilder.put((Object)KEY_INNER, (Object)this.in);
        }
        if (this.grip.exists()) {
            partBuilder.put((Object)KEY_GRIP, (Object)this.grip);
        }
        LaserBladeModelData modelData = new LaserBladeModelData(this.type, (Map<String, LaserBladeModelData.PartData>)partBuilder.build());
        itemStack.set(ModDataComponents.LASER_BLADE_MODEL, (Object)modelData);
    }

    private void setColorsByNetherBiome(Level level, Holder<Biome> biomeHolder) {
        if (this.compareBiomes(biomeHolder, (ResourceKey<Biome>)Biomes.SOUL_SAND_VALLEY) || this.compareBiomes(biomeHolder, (ResourceKey<Biome>)Biomes.WARPED_FOREST)) {
            this.setColor(LaserBladeColor.BIOME_NETHER_B);
        } else {
            this.setColor(LaserBladeColor.BIOME_NETHER_A);
        }
    }

    private void setColorsByEndBiome(Level level, Holder<Biome> biomeHolder) {
        this.setColor(LaserBladeColor.BIOME_END);
    }

    private void setColorsByOverWorldBiome(Level level, Holder<Biome> biomeHolder) {
        if (this.compareBiomes(biomeHolder, (ResourceKey<Biome>)Biomes.DEEP_DARK)) {
            this.setColor(LaserBladeColor.BIOME_DEEP_DARK);
            this.type = 2;
        } else if (this.compareBiomes(biomeHolder, (ResourceKey<Biome>)Biomes.CHERRY_GROVE)) {
            this.setColor(LaserBladeColor.BIOME_CHERRY_GROVE);
        } else if (this.compareBiomes(biomeHolder, (ResourceKey<Biome>)Biomes.PALE_GARDEN)) {
            this.setColor(LaserBladeColor.BIOME_PALE_GARDEN);
        } else {
            float temp = ((Biome)biomeHolder.value()).getBaseTemperature();
            this.setOuterColor(LaserBladeColor.getColorByTemperature(temp).getOuterColor());
        }
    }

    private boolean compareBiomes(Holder<Biome> biomeHolder, ResourceKey<Biome> biomeKey) {
        if (biomeHolder == null) {
            return false;
        }
        return biomeHolder.is(biomeKey);
    }
}

