/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade;

import com.github.iunius118.tolaserblade.common.util.ModSoundEventRegistry;
import com.github.iunius118.tolaserblade.common.util.ModSoundEvents;
import com.github.iunius118.tolaserblade.config.TLBServerConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.BlocksAttacks;
import net.neoforged.neoforge.registries.DeferredHolder;

public class LaserBladeBlocking {
    public static boolean isShield() {
        return TLBServerConfig.isEnabledBlockingWithLaserBlade;
    }

    public static boolean isBlockingSound(Holder<SoundEvent> sound) {
        if (sound != null) {
            return sound.is(ModSoundEvents.ITEM_LASER_BLADE_BLOCK.location()) || sound.is(ModSoundEvents.ITEM_LASER_BLADE_FP_BLOCK.location());
        }
        return false;
    }

    public static BlocksAttacks getBlocksAttackComponent(boolean isFireResistant) {
        DeferredHolder<SoundEvent, SoundEvent> blockingSoundEvent = isFireResistant ? ModSoundEventRegistry.ITEM_LASER_BLADE_FP_BLOCK : ModSoundEventRegistry.ITEM_LASER_BLADE_BLOCK;
        return new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(90.0f, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(blockingSoundEvent), Optional.of(SoundEvents.SHIELD_BREAK));
    }

    public static ItemUseAnimation getUseAnimation(ItemStack stack) {
        if (LaserBladeBlocking.isShield()) {
            return ItemUseAnimation.BLOCK;
        }
        Optional patched = stack.getComponentsPatch().get(DataComponents.BLOCKS_ATTACKS);
        if (patched != null && patched.isPresent()) {
            return ItemUseAnimation.BLOCK;
        }
        return ItemUseAnimation.NONE;
    }

    public static InteractionResult use(Player player, InteractionHand hand) {
        if (LaserBladeBlocking.isShield()) {
            player.startUsingItem(hand);
            return InteractionResult.CONSUME;
        }
        ItemStack stack = player.getItemInHand(hand);
        Optional patched = stack.getComponentsPatch().get(DataComponents.BLOCKS_ATTACKS);
        if (patched != null && patched.isPresent()) {
            player.startUsingItem(hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

