/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade;

import net.minecraft.util.Mth;

public enum LaserBladeColor {
    WHITE(-1, -393218, "white"),
    ORANGE(-38881, -425955, "orange"),
    MAGENTA(-65408, -3715395, "magenta"),
    LIGHT_BLUE(-16733441, -12930086, "light_blue"),
    YELLOW(-4608, -75715, "yellow"),
    LIME(-5636302, -8337633, "lime"),
    PINK(-65460, -816214, "pink"),
    GRAY(-11184811, -12103854, "gray"),
    LIGHT_GRAY(-5592406, -6447721, "light_gray"),
    CYAN(-16711681, -15295332, "cyan"),
    PURPLE(-65281, -7785800, "purple"),
    BLUE(-16776961, -12827478, "blue"),
    BROWN(-38144, -8170446, "brown"),
    GREEN(-8323328, -10585066, "green"),
    RED(-65536, -5231066, "red"),
    BLACK(-16645630, -14869215, "black"),
    TEMP_DESERT(-6291201, -393218, "temp_desert"),
    TEMP_STONY_PEAKS(-65332, -393218, "temp_stony_peaks"),
    TEMP_JUNGLE(-15360, -393218, "temp_jungle"),
    TEMP_TAIGA(-16711936, -393218, "temp_taiga"),
    TEMP_SNOWY_PLAINS(-16744193, -393218, "temp_snowy_plains"),
    TEMP_SNOWY_TAIGA(-16764673, -393218, "temp_snowy_taiga"),
    BIOME_DEEP_DARK(-16711681, -336681, -16440536, false, true, "biome_deep_dark"),
    BIOME_CHERRY_GROVE(-65460, -336656, -11850436, "biome_cherry_grove"),
    BIOME_PALE_GARDEN(-1281516, -1072329, -9935774, "biome_pale_garden"),
    BIOME_NETHER_A(-1, -393218, false, true, "biome_nether_a"),
    BIOME_NETHER_B(-1, -393218, true, false, "biome_nether_b"),
    BIOME_END(-1, -393218, true, true, "biome_end"),
    SPECIAL_GAMING(-16711423, -16711423, "special_gaming"),
    SPECIAL_SWITCH_BLEND_MODE(0x1010101, 0x1010101, "special_sbm");

    private final int outerColor;
    private final int innerColor;
    private final int gripColor;
    private final boolean isOuterSubColor;
    private final boolean isInnerSubColor;
    private final String colorName;

    private LaserBladeColor(int outerColor, int innerColor, int gripColor, boolean isOuterSubColor, boolean isInnerSubColor, String colorName) {
        this.outerColor = outerColor;
        this.innerColor = innerColor;
        this.gripColor = gripColor;
        this.isOuterSubColor = isOuterSubColor;
        this.isInnerSubColor = isInnerSubColor;
        this.colorName = colorName;
    }

    private LaserBladeColor(int bladeColor, int gripColor, boolean isOuterSubColor, boolean isInnerSubColor, String colorName) {
        this(bladeColor, bladeColor, gripColor, isOuterSubColor, isInnerSubColor, colorName);
    }

    private LaserBladeColor(int outerColor, int innerColor, int gripColor, String colorName) {
        this(outerColor, innerColor, gripColor, false, false, colorName);
    }

    private LaserBladeColor(int bladeColor, int gripColor, String colorName) {
        this(bladeColor, bladeColor, gripColor, colorName);
    }

    public static LaserBladeColor get(int index) {
        LaserBladeColor[] values = LaserBladeColor.values();
        return values[Mth.clamp((int)index, (int)0, (int)(values.length - 1))];
    }

    public static LaserBladeColor getColorByTemperature(float temp) {
        if (temp > 1.5f) {
            return TEMP_DESERT;
        }
        if (temp >= 1.0f) {
            return TEMP_STONY_PEAKS;
        }
        if (temp > 0.8f) {
            return TEMP_JUNGLE;
        }
        if (temp >= 0.5f) {
            return RED;
        }
        if (temp >= 0.2f) {
            return TEMP_TAIGA;
        }
        if (temp >= -0.3f) {
            return TEMP_SNOWY_PLAINS;
        }
        return TEMP_SNOWY_TAIGA;
    }

    public int getBladeColor() {
        return this.outerColor;
    }

    public int getOuterColor() {
        return this.outerColor;
    }

    public int getInnerColor() {
        return this.innerColor;
    }

    public int getGripColor() {
        return this.gripColor;
    }

    public boolean isOuterSubColor() {
        return this.isOuterSubColor;
    }

    public boolean isInnerSubColor() {
        return this.isInnerSubColor;
    }

    public String getColorName() {
        return this.colorName;
    }
}

