/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade;

import com.github.iunius118.tolaserblade.core.component.ModDataComponents;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class LaserBladeDataMigrator {
    public static final String OLD_KEY_ATK = "ATK";
    public static final String OLD_KEY_SPD = "SPD";
    public static final String OLD_KEY_MODEL_TYPE = "type";
    public static final String OLD_KEY_INNER_COLOR = "colorC";
    public static final String OLD_KEY_IS_INNER_SUB_COLOR = "isSubC";
    public static final String OLD_KEY_OUTER_COLOR = "colorH";
    public static final String OLD_KEY_IS_OUTER_SUB_COLOR = "isSubH";
    public static final String OLD_KEY_GRIP_COLOR = "colorG";

    private LaserBladeDataMigrator() {
    }

    public static float getAttack(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return 0.0f;
        }
        CompoundTag tag = customData.copyTag();
        if (!tag.contains(OLD_KEY_ATK)) {
            return 0.0f;
        }
        float attack = Mth.clamp((float)tag.getFloatOr(OLD_KEY_ATK, 0.0f), (float)0.0f, (float)4194304.0f);
        itemStack.set(ModDataComponents.LASER_BLADE_ATTACK, (Object)Float.valueOf(attack));
        tag.remove(OLD_KEY_ATK);
        if (tag.isEmpty()) {
            itemStack.remove(DataComponents.CUSTOM_DATA);
        } else {
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return attack;
    }

    public static float getSpeed(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return 0.0f;
        }
        CompoundTag tag = customData.copyTag();
        if (!tag.contains(OLD_KEY_SPD)) {
            return 0.0f;
        }
        float speed = Mth.clamp((float)tag.getFloatOr(OLD_KEY_SPD, 0.0f), (float)0.0f, (float)1.2f);
        itemStack.set(ModDataComponents.LASER_BLADE_SPEED, (Object)Float.valueOf(speed));
        tag.remove(OLD_KEY_SPD);
        if (tag.isEmpty()) {
            itemStack.remove(DataComponents.CUSTOM_DATA);
        } else {
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return speed;
    }

    public static LaserBladeAppearance getAppearance(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        LaserBladeAppearance appearance = LaserBladeAppearance.of();
        if (customData == null) {
            return appearance;
        }
        boolean isDataUpdated = false;
        CompoundTag tag = customData.copyTag();
        if (tag.contains(OLD_KEY_MODEL_TYPE)) {
            isDataUpdated = true;
            appearance.setType(tag.getIntOr(OLD_KEY_MODEL_TYPE, 0));
            tag.remove(OLD_KEY_MODEL_TYPE);
        }
        if (tag.contains(OLD_KEY_OUTER_COLOR)) {
            isDataUpdated = true;
            tag.getInt(OLD_KEY_OUTER_COLOR).ifPresent(appearance::setOuterColor);
            tag.remove(OLD_KEY_OUTER_COLOR);
        }
        if (tag.contains(OLD_KEY_IS_OUTER_SUB_COLOR)) {
            isDataUpdated = true;
            tag.getBoolean(OLD_KEY_IS_OUTER_SUB_COLOR).ifPresent(appearance::setOuterSubColor);
            tag.remove(OLD_KEY_IS_OUTER_SUB_COLOR);
        }
        if (tag.contains(OLD_KEY_INNER_COLOR)) {
            isDataUpdated = true;
            tag.getInt(OLD_KEY_INNER_COLOR).ifPresent(appearance::setInnerColor);
            tag.remove(OLD_KEY_INNER_COLOR);
        }
        if (tag.contains(OLD_KEY_IS_INNER_SUB_COLOR)) {
            isDataUpdated = true;
            tag.getBoolean(OLD_KEY_IS_INNER_SUB_COLOR).ifPresent(appearance::setInnerSubColor);
            tag.remove(OLD_KEY_IS_INNER_SUB_COLOR);
        }
        if (tag.contains(OLD_KEY_GRIP_COLOR)) {
            isDataUpdated = true;
            tag.getInt(OLD_KEY_GRIP_COLOR).ifPresent(appearance::setGripColor);
            tag.remove(OLD_KEY_GRIP_COLOR);
        }
        if (!isDataUpdated) {
            return appearance;
        }
        appearance.setTo(itemStack);
        if (tag.isEmpty()) {
            itemStack.remove(DataComponents.CUSTOM_DATA);
        } else {
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return appearance;
    }
}

