/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade.upgrade;

import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeResult;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrader;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class EnchantmentUpgrader
implements Upgrader {
    private final ResourceKey<Enchantment> enchantment;

    public EnchantmentUpgrader(ResourceKey<Enchantment> enchantment) {
        this.enchantment = enchantment;
    }

    public static EnchantmentUpgrader of(ResourceKey<Enchantment> enchantment) {
        return new EnchantmentUpgrader(enchantment);
    }

    @Override
    public boolean canApply(ItemStack base, ItemStack addition, HolderLookup.Provider provider) {
        Optional optionalHolder = provider.lookupOrThrow(Registries.ENCHANTMENT).get(this.enchantment);
        if (optionalHolder.isEmpty()) {
            return false;
        }
        Holder.Reference enchantmentHolder = (Holder.Reference)optionalHolder.get();
        int level = base.getEnchantmentLevel((Holder)enchantmentHolder);
        return level < ((Enchantment)enchantmentHolder.value()).getMaxLevel();
    }

    @Override
    public UpgradeResult apply(ItemStack base, int baseCost, HolderLookup.Provider provider) {
        Optional optionalHolder = provider.lookupOrThrow(Registries.ENCHANTMENT).get(this.enchantment);
        if (optionalHolder.isEmpty()) {
            return UpgradeResult.of(base, baseCost);
        }
        Holder.Reference enchantmentHolder = (Holder.Reference)optionalHolder.get();
        int cost = baseCost;
        int level = base.getEnchantmentLevel((Holder)enchantmentHolder);
        if (level < ((Enchantment)enchantmentHolder.value()).getMaxLevel()) {
            EnchantmentHelper.updateEnchantments((ItemStack)base, m -> {
                m.removeIf(e -> !this.isCompatibleWith((Holder<Enchantment>)e, (Holder<Enchantment>)enchantmentHolder));
                m.set((Holder)enchantmentHolder, level + 1);
            });
            cost += this.getCost((Holder<Enchantment>)enchantmentHolder, level);
        }
        return UpgradeResult.of(base, cost);
    }

    private boolean isCompatibleWith(Holder<Enchantment> e1, Holder<Enchantment> e2) {
        return Enchantment.areCompatible(e1, e2) || e1.is(Enchantments.SILK_TOUCH) && e2.is(Enchantments.LOOTING) || e1.is(Enchantments.LOOTING) && e2.is(Enchantments.SILK_TOUCH);
    }

    private int getCost(Holder<Enchantment> enchantmentHolder, int newLevel) {
        int rate = Math.max(((Enchantment)enchantmentHolder.value()).getAnvilCost() / 2, 1);
        return Math.max(rate * newLevel, 1);
    }
}

