/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade.upgrade;

import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeResult;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrader;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class RemoveEfficiencyUpgrader
implements Upgrader {
    @Override
    public boolean canApply(ItemStack base, ItemStack addition, HolderLookup.Provider provider) {
        Optional optionalHolder = provider.lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.EFFICIENCY);
        if (optionalHolder.isEmpty()) {
            return false;
        }
        Holder.Reference efficiency = (Holder.Reference)optionalHolder.get();
        int level = base.getEnchantmentLevel((Holder)efficiency);
        return level > 0;
    }

    @Override
    public UpgradeResult apply(ItemStack base, int baseCost, HolderLookup.Provider provider) {
        Optional optionalHolder = provider.lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.EFFICIENCY);
        if (optionalHolder.isEmpty()) {
            return UpgradeResult.of(base, baseCost);
        }
        Holder.Reference efficiency = (Holder.Reference)optionalHolder.get();
        int cost = baseCost;
        int level = base.getEnchantmentLevel((Holder)efficiency);
        if (level > 0) {
            EnchantmentHelper.updateEnchantments((ItemStack)base, m -> m.removeIf(e -> e.is(Enchantments.EFFICIENCY)));
            ++cost;
        }
        return UpgradeResult.of(base, cost);
    }
}

