/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade.upgrade;

import com.github.iunius118.tolaserblade.core.laserblade.LaserBlade;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeResult;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrader;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;

public class SpeedUpgrader
implements Upgrader {
    @Override
    public boolean canApply(ItemStack base, ItemStack addition, HolderLookup.Provider provider) {
        float speed = LaserBlade.getSpeed(base);
        return LaserBlade.canUpgradeSpeed(speed);
    }

    @Override
    public UpgradeResult apply(ItemStack base, int baseCost, HolderLookup.Provider provider) {
        float speed = LaserBlade.getSpeed(base);
        int cost = baseCost;
        if (LaserBlade.canUpgradeSpeed(speed)) {
            LaserBlade.setSpeed(base, speed += 0.4f);
            LaserBlade.updateItemAttributeModifiers(base);
            cost += this.getCost(speed);
        }
        return UpgradeResult.of(base, cost);
    }

    private int getCost(float newSpeed) {
        return Math.max((int)(newSpeed / 0.4f), 1);
    }
}

