/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade.upgrade;

import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeResult;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrader;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record Upgrade(Upgrader upgrader, TagKey<Item> ingredientItemTag, String shortName) {
    public static final Upgrade NONE = new Upgrade(new Upgrader(){

        @Override
        public boolean canApply(ItemStack base, ItemStack addition, HolderLookup.Provider provider) {
            return false;
        }

        @Override
        public UpgradeResult apply(ItemStack base, int baseCost, HolderLookup.Provider provider) {
            return UpgradeResult.of(base, baseCost);
        }
    }, null, "00");

    public Optional<Ingredient> getIngredient() {
        if (this.ingredientItemTag == null) {
            return Optional.empty();
        }
        Optional itemHolderSet = BuiltInRegistries.ITEM.get(this.ingredientItemTag);
        return itemHolderSet.map(Ingredient::of);
    }

    public boolean canApply(ItemStack base, ItemStack addition, HolderLookup.Provider provider) {
        return this.upgrader.canApply(base, addition, provider);
    }

    public UpgradeResult apply(ItemStack base, int baseCost, HolderLookup.Provider provider) {
        return this.upgrader.apply(base, baseCost, provider);
    }

    public static enum Type {
        BATTERY,
        MEDIUM,
        EMITTER,
        CASING,
        REPAIR,
        OTHER;

    }
}

