/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.core.laserblade.upgrade;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.AttackUpgrader;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.EnchantmentUpgrader;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.FireproofUpgrader;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.RemoveEfficiencyUpgrader;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.RepairUpgrader;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.SpeedUpgrader;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrade;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeID;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrader;
import com.github.iunius118.tolaserblade.tags.ModItemTags;
import com.github.iunius118.tolaserblade.world.item.enchantment.ModEnchantments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.common.Tags;

public class UpgradeManager {
    private static final Map<ResourceLocation, Upgrade> upgrades = new HashMap<ResourceLocation, Upgrade>();

    private static void register(UpgradeID id, TagKey<Item> ingredientItemTag, Upgrader upgrader) {
        Upgrade upgrade = new Upgrade(upgrader, ingredientItemTag, id.getShortName());
        upgrades.put(id.getID(), upgrade);
    }

    private static void registerEnchantment(UpgradeID id, TagKey<Item> ingredientItemTag, ResourceKey<Enchantment> enchantment) {
        Upgrade upgrade = new Upgrade(EnchantmentUpgrader.of(enchantment), ingredientItemTag, id.getShortName());
        upgrades.put(id.getID(), upgrade);
    }

    public static Map<ResourceLocation, Upgrade> getUpgrades() {
        return upgrades;
    }

    public static Upgrade getUpgrade(ResourceLocation key) {
        Upgrade upgrade = upgrades.get(key);
        if (upgrade == null) {
            ToLaserBlade.LOGGER.warn("[ToLaserBlade] Upgrade {} was not found in UpgradeManager", (Object)key.toString());
            upgrade = Upgrade.NONE;
        }
        return upgrade;
    }

    public static Upgrade getUpgrade(UpgradeID id) {
        return UpgradeManager.getUpgrade(id.getID());
    }

    public static List<Upgrade> getUpgradeList(ItemStack additionalItem) {
        ArrayList<Upgrade> list = new ArrayList<Upgrade>();
        upgrades.forEach((key, upgrade) -> upgrade.getIngredient().ifPresent(i -> {
            if (i.test(additionalItem)) {
                list.add((Upgrade)upgrade);
            }
        }));
        return list;
    }

    static {
        UpgradeManager.registerEnchantment(UpgradeID.EFFICIENCY_UPGRADE, ModItemTags.EFFICIENCY_UPGRADE, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
        UpgradeManager.registerEnchantment(UpgradeID.LIGHT_ELEMENT_UPGRADE, ModItemTags.LIGHT_ELEMENT_UPGRADE, ModEnchantments.LIGHT_ELEMENT);
        UpgradeManager.registerEnchantment(UpgradeID.FIRE_ASPECT_UPGRADE, ModItemTags.FIRE_ASPECT_UPGRADE, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT);
        UpgradeManager.registerEnchantment(UpgradeID.SWEEPING_EDGE_UPGRADE, ModItemTags.SWEEPING_EDGE_UPGRADE, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE);
        UpgradeManager.registerEnchantment(UpgradeID.SILK_TOUCH_UPGRADE, ModItemTags.SILK_TOUCH_UPGRADE, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH);
        UpgradeManager.registerEnchantment(UpgradeID.LOOTING_UPGRADE, ModItemTags.LOOTING_UPGRADE, (ResourceKey<Enchantment>)Enchantments.LOOTING);
        UpgradeManager.registerEnchantment(UpgradeID.MENDING_UPGRADE, ModItemTags.MENDING_UPGRADE, (ResourceKey<Enchantment>)Enchantments.MENDING);
        UpgradeManager.register(UpgradeID.EFFICIENCY_REMOVER, ModItemTags.EFFICIENCY_REMOVER, new RemoveEfficiencyUpgrader());
        UpgradeManager.register(UpgradeID.ATTACK_DAMAGE_UPGRADE, ModItemTags.ATTACK_DAMAGE_UPGRADE, new AttackUpgrader());
        UpgradeManager.register(UpgradeID.ATTACK_SPEED_UPGRADE, ModItemTags.ATTACK_SPEED_UPGRADE, new SpeedUpgrader());
        UpgradeManager.register(UpgradeID.REPAIR_UPGRADE, ModItemTags.CASING_REPAIR, new RepairUpgrader());
        UpgradeManager.register(UpgradeID.FIREPROOF_UPGRADE, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, new FireproofUpgrader());
    }
}

