/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.data;

import com.github.iunius118.tolaserblade.core.component.predicates.LaserBladeAttackPredicate;
import com.github.iunius118.tolaserblade.core.component.predicates.ModDataComponentPredicates;
import com.github.iunius118.tolaserblade.world.item.LBSwordItem;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemStack;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemUtil;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import com.github.iunius118.tolaserblade.world.item.ModToolMaterials;
import com.github.iunius118.tolaserblade.world.item.enchantment.ModEnchantments;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemDurabilityTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class TLBAdvancementProvider
extends AdvancementProvider {
    public TLBAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, List.of(new TLBAdvancementGenerator()));
    }

    private static class TLBAdvancementGenerator
    implements AdvancementSubProvider {
        private TLBAdvancementGenerator() {
        }

        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> writer) {
            HolderLookup.RegistryLookup itemRegistryLookup = registries.lookupOrThrow(Registries.ITEM);
            AdvancementHolder root = Advancement.Builder.recipeAdvancement().display(LaserBladeItemStack.ICON.getCopy(registries), (Component)Component.translatable((String)"advancements.tolaserblade.main.root.title"), (Component)Component.translatable((String)"advancements.tolaserblade.main.root.description"), ResourceLocation.withDefaultNamespace((String)"block/polished_andesite"), AdvancementType.TASK, false, false, false).addCriterion("has_redstone", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.REDSTONE})).addCriterion("has_dx_laser_blade", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.DX_LASER_BLADE})).addCriterion("has_laser_blade", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.LASER_BLADE})).addCriterion("has_laser_blade_fp", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.LASER_BLADE_FP})).requirements(AdvancementRequirements.Strategy.OR).save(writer, "tolaserblade:main/root");
            AdvancementHolder dxLaserBlade = this.registerItemAdvancement(root, ModItems.DX_LASER_BLADE, AdvancementType.TASK, new Item[]{ModItems.DX_LASER_BLADE}, writer);
            AdvancementHolder laserBlade = this.registerItemAdvancement(dxLaserBlade, ModItems.LASER_BLADE, AdvancementType.TASK, new Item[]{ModItems.LASER_BLADE, ModItems.LASER_BLADE_FP}, writer);
            AdvancementHolder lightElement5 = this.registerEnchantmentAdvancement(laserBlade, Items.GLOWSTONE, AdvancementType.TASK, new Item[]{ModItems.LASER_BLADE, ModItems.LASER_BLADE_FP}, ModEnchantments.LIGHT_ELEMENT, 5, registries, writer);
            AdvancementHolder lightElement10 = this.registerEnchantmentAdvancement(lightElement5, Items.GLOWSTONE, AdvancementType.TASK, new Item[]{ModItems.LASER_BLADE, ModItems.LASER_BLADE_FP}, ModEnchantments.LIGHT_ELEMENT, 10, registries, writer);
            AdvancementHolder attack10 = this.registerAttackUpgradeAdvancement(laserBlade, Items.DIAMOND_BLOCK, AdvancementType.TASK, new Item[]{ModItems.LASER_BLADE, ModItems.LASER_BLADE_FP}, 10, registries, writer);
            AdvancementHolder attack15 = this.registerAttackUpgradeAdvancement(attack10, Items.DIAMOND_BLOCK, AdvancementType.TASK, new Item[]{ModItems.LASER_BLADE, ModItems.LASER_BLADE_FP}, 15, registries, writer);
            AdvancementHolder looting3 = this.registerEnchantmentAdvancement(laserBlade, Items.NAUTILUS_SHELL, AdvancementType.TASK, new Item[]{ModItems.LASER_BLADE, ModItems.LASER_BLADE_FP}, (ResourceKey<Enchantment>)Enchantments.LOOTING, 3, registries, writer);
            AdvancementHolder breakLaserBlade = Advancement.Builder.recipeAdvancement().parent(laserBlade).display((ItemLike)ModItems.LB_CASING, (Component)Component.translatable((String)"advancements.tolaserblade.main.break_laser_blade.title"), (Component)Component.translatable((String)"advancements.tolaserblade.main.break_laser_blade.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)1000)).requirements(AdvancementRequirements.Strategy.OR).addCriterion("broke_laser_blade", ItemDurabilityTrigger.TriggerInstance.changedDurability(Optional.of(ItemPredicate.Builder.item().of((HolderGetter)itemRegistryLookup, new ItemLike[]{ModItems.LASER_BLADE}).build()), (MinMaxBounds.Ints)MinMaxBounds.Ints.atMost((int)0))).addCriterion("broke_laser_blade_fp", ItemDurabilityTrigger.TriggerInstance.changedDurability(Optional.of(ItemPredicate.Builder.item().of((HolderGetter)itemRegistryLookup, new ItemLike[]{ModItems.LASER_BLADE_FP}).build()), (MinMaxBounds.Ints)MinMaxBounds.Ints.atMost((int)0))).save(writer, "tolaserblade:main/break_laser_blade");
            AdvancementHolder mending = this.registerEnchantmentAdvancement(laserBlade, Items.NETHER_STAR, AdvancementType.GOAL, new Item[]{ModItems.LASER_BLADE, ModItems.LASER_BLADE_FP}, (ResourceKey<Enchantment>)Enchantments.MENDING, 1, registries, writer);
            AdvancementHolder laserBladeFP = this.registerItemAdvancement(laserBlade, Items.NETHERITE_INGOT, AdvancementType.TASK, new Item[]{ModItems.LASER_BLADE_FP}, writer);
        }

        private AdvancementHolder registerItemAdvancement(AdvancementHolder parent, Item icon, AdvancementType advancementType, Item[] requirements, Consumer<AdvancementHolder> consumer) {
            String name = this.getItemId(requirements[0]).getPath();
            Advancement.Builder builder = Advancement.Builder.recipeAdvancement().parent(parent).display((ItemLike)icon, (Component)Component.translatable((String)("advancements.tolaserblade.main." + name + ".title")), (Component)Component.translatable((String)("advancements.tolaserblade.main." + name + ".description")), null, advancementType, true, true, false).requirements(AdvancementRequirements.Strategy.OR);
            for (Item item : requirements) {
                String itemName = this.getItemId(item).getPath();
                builder.addCriterion("has_" + itemName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
            }
            return builder.save(consumer, "tolaserblade:main/" + name);
        }

        private AdvancementHolder registerEnchantmentAdvancement(AdvancementHolder parent, Item icon, AdvancementType advancementType, Item[] requirements, ResourceKey<Enchantment> enchantment, int level, HolderLookup.Provider lookupProvider, Consumer<AdvancementHolder> consumer) {
            Holder.Reference enchantmentHolder = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchantment);
            String name = this.getItemId(requirements[0]).getPath() + "_" + this.getEnchantmentId((Holder<Enchantment>)enchantmentHolder).getPath() + "_" + level;
            HolderLookup.RegistryLookup itemRegistryLookup = lookupProvider.lookupOrThrow(Registries.ITEM);
            Advancement.Builder builder = Advancement.Builder.recipeAdvancement().parent(parent).display((ItemLike)icon, (Component)Component.translatable((String)("advancements.tolaserblade.main." + name + ".title")), (Component)Component.translatable((String)("advancements.tolaserblade.main." + name + ".description")), null, advancementType, true, true, false).requirements(AdvancementRequirements.Strategy.OR);
            for (Item item : requirements) {
                String itemName = this.getItemId(item).getPath();
                ItemPredicate itemPredicate = ItemPredicate.Builder.item().of((HolderGetter)itemRegistryLookup, new ItemLike[]{item}).withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.ENCHANTMENTS, (DataComponentPredicate)EnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantmentHolder, MinMaxBounds.Ints.atLeast((int)level))))).build()).build();
                builder.addCriterion("has_" + itemName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{itemPredicate}));
            }
            return builder.save(consumer, "tolaserblade:main/" + name);
        }

        private AdvancementHolder registerAttackUpgradeAdvancement(AdvancementHolder parent, Item icon, AdvancementType advancementType, Item[] requirements, int attackDamage, HolderLookup.Provider lookupProvider, Consumer<AdvancementHolder> consumer) {
            String name = this.getItemId(requirements[0]).getPath() + "_attack_" + attackDamage;
            Advancement.Builder builder = Advancement.Builder.recipeAdvancement().parent(parent).display((ItemLike)icon, (Component)Component.translatable((String)("advancements.tolaserblade.main." + name + ".title")), (Component)Component.translatable((String)("advancements.tolaserblade.main." + name + ".description")), null, advancementType, true, true, false).requirements(AdvancementRequirements.Strategy.OR);
            int maxAtk = 8;
            HolderLookup.RegistryLookup itemRegistryLookup = lookupProvider.lookupOrThrow(Registries.ITEM);
            for (Item item : requirements) {
                String itemName = this.getItemId(item).getPath();
                int baseDamage = 1;
                if (item instanceof LBSwordItem) {
                    LBSwordItem laserBlase = (LBSwordItem)item;
                    boolean isFireResistant = LaserBladeItemUtil.isFireResistant(laserBlase.getDefaultInstance());
                    float attackDamageBonus = ModToolMaterials.getLBSwordMaterial(isFireResistant).attackDamageBonus();
                    baseDamage += (int)(attackDamageBonus + 3.0f);
                }
                for (int i = attackDamage - baseDamage; i >= 0 && i <= maxAtk; ++i) {
                    ItemPredicate itemPredicate = ItemPredicate.Builder.item().of((HolderGetter)itemRegistryLookup, new ItemLike[]{item}).withComponents(DataComponentMatchers.Builder.components().partial(ModDataComponentPredicates.LASER_BLADE_ATTACK, (DataComponentPredicate)new LaserBladeAttackPredicate(Float.valueOf(i))).build()).build();
                    builder.addCriterion(itemName + "_attack_" + (i + baseDamage), InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{itemPredicate}));
                }
            }
            return builder.save(consumer, "tolaserblade:main/" + name);
        }

        private ResourceLocation getItemId(Item item) {
            return BuiltInRegistries.ITEM.getKey((Object)item);
        }

        private ResourceLocation getEnchantmentId(Holder<Enchantment> enchantment) {
            return ((ResourceKey)enchantment.unwrapKey().orElseThrow()).location();
        }
    }
}

