/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.data;

import com.github.iunius118.tolaserblade.data.TLBAdvancementProvider;
import com.github.iunius118.tolaserblade.data.TLBBlockTagsProvider;
import com.github.iunius118.tolaserblade.data.TLBEnchantmentTagsProvider;
import com.github.iunius118.tolaserblade.data.TLBEntityTypeTagsProvider;
import com.github.iunius118.tolaserblade.data.TLBItemTagsProvider;
import com.github.iunius118.tolaserblade.data.TLBLanguageProvider;
import com.github.iunius118.tolaserblade.data.TLBModelProvider;
import com.github.iunius118.tolaserblade.data.TLBOldRecipeProvider6;
import com.github.iunius118.tolaserblade.data.TLBRecipeProvider;
import com.github.iunius118.tolaserblade.data.TLBSampleSoundPackProvider;
import com.github.iunius118.tolaserblade.data.TLBSoundDefinitionsProvider;
import com.github.iunius118.tolaserblade.world.item.enchantment.LightElementEnchantment;
import com.github.iunius118.tolaserblade.world.item.enchantment.ModEnchantments;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class TLBDataGenerator {
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        DatapackBuiltinEntriesProvider builtinEntriesProvider = new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), TLBDataGenerator.getEntriesBuilder(), Set.of("tolaserblade"));
        CompletableFuture lookupProvider = builtinEntriesProvider.getRegistryProvider();
        TLBBlockTagsProvider blockTagsProvider = new TLBBlockTagsProvider(packOutput, lookupProvider);
        event.addProvider((DataProvider)builtinEntriesProvider);
        event.addProvider((DataProvider)new TLBRecipeProvider.Runner(packOutput, lookupProvider));
        event.addProvider((DataProvider)blockTagsProvider);
        event.addProvider((DataProvider)new TLBItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter()));
        event.addProvider((DataProvider)new TLBEntityTypeTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new TLBEnchantmentTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new TLBAdvancementProvider(packOutput, lookupProvider));
        TLBOldRecipeProvider6.addProviders((GatherDataEvent)event);
        event.addProvider((DataProvider)new TLBModelProvider(packOutput));
        TLBLanguageProvider.addProviders(event);
        event.addProvider((DataProvider)new TLBSoundDefinitionsProvider(packOutput));
        TLBSampleSoundPackProvider.addProviders((GatherDataEvent)event);
    }

    private static RegistrySetBuilder getEntriesBuilder() {
        RegistrySetBuilder.RegistryBootstrap enchantmentRegistry = bootstrapContext -> {
            HolderGetter itemGetter = bootstrapContext.lookup(Registries.ITEM);
            HolderGetter enchantmentGetter = bootstrapContext.lookup(Registries.ENCHANTMENT);
            HolderGetter entityTypeHolderGetter = bootstrapContext.lookup(Registries.ENTITY_TYPE);
            bootstrapContext.register(ModEnchantments.LIGHT_ELEMENT, (Object)LightElementEnchantment.get((HolderGetter<Item>)itemGetter, (HolderGetter<Enchantment>)enchantmentGetter, entityTypeHolderGetter));
        };
        return new RegistrySetBuilder().add(Registries.ENCHANTMENT, enchantmentRegistry);
    }
}

