/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.data;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.client.color.item.LaserBladeTintSource;
import com.github.iunius118.tolaserblade.client.renderer.item.LBSwordSpecialRenderer;
import com.github.iunius118.tolaserblade.client.renderer.item.model.LBSwordItemTransforms;
import com.github.iunius118.tolaserblade.client.renderer.item.properties.Blocking;
import com.github.iunius118.tolaserblade.client.renderer.item.properties.UsingOriginalModel;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeColorPart;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.color.item.Constant;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.MainHand;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Vector3fc;

public class TLBModelProvider
extends ModelProvider {
    public TLBModelProvider(PackOutput packOutput) {
        super(packOutput, "tolaserblade");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.generateItemModels(itemModels);
    }

    private void generateItemModels(ItemModelGenerators itemModelGenerator) {
        ItemModelOutput itemModelOutput = itemModelGenerator.itemModelOutput;
        BiConsumer modelOutput = itemModelGenerator.modelOutput;
        itemModelGenerator.generateFlatItem(ModItems.DX_LASER_BLADE, ModelTemplates.FLAT_HANDHELD_ITEM);
        ItemModel.Unbaked lbSwordModel = this.generateLBSwordModel(ModItems.LASER_BLADE, modelOutput);
        itemModelOutput.register(ModItems.LASER_BLADE, new ClientItem(lbSwordModel, new ClientItem.Properties(true, true)));
        itemModelOutput.register(ModItems.LASER_BLADE_FP, new ClientItem(lbSwordModel, new ClientItem.Properties(true, true)));
        itemModelOutput.accept(ModItems.LB_BLUEPRINT, ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)ModItems.LB_BLUEPRINT), TextureMapping.layer0((ResourceLocation)ToLaserBlade.makeId("item/parts/lb_blueprint")), modelOutput)));
        itemModelOutput.accept(ModItems.LB_BATTERY, ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)ModItems.LB_BATTERY), TextureMapping.layer0((ResourceLocation)ToLaserBlade.makeId("item/parts/lb_battery")), modelOutput)));
        itemModelOutput.accept(ModItems.LB_MEDIUM, ItemModelUtils.tintedModel((ResourceLocation)itemModelGenerator.generateLayeredItem(ModItems.LB_MEDIUM, ToLaserBlade.makeId("item/parts/lb_medium_0"), ToLaserBlade.makeId("item/parts/lb_medium_1")), (ItemTintSource[])new ItemTintSource[]{new Constant(0xFFFFFF), new LaserBladeTintSource(LaserBladeColorPart.OUTER_BLADE)}));
        itemModelOutput.accept(ModItems.LB_EMITTER, ItemModelUtils.tintedModel((ResourceLocation)itemModelGenerator.generateLayeredItem(ModItems.LB_EMITTER, ToLaserBlade.makeId("item/parts/lb_emitter_0"), ToLaserBlade.makeId("item/parts/lb_emitter_1")), (ItemTintSource[])new ItemTintSource[]{new Constant(0xFFFFFF), new LaserBladeTintSource(LaserBladeColorPart.INNER_BLADE)}));
        ItemModel.Unbaked vanillaCasingModel = ItemModelUtils.tintedModel((ResourceLocation)ModelTemplates.FLAT_HANDHELD_ITEM.create(ModelLocationUtils.getModelLocation((Item)ModItems.LB_CASING), TextureMapping.layer0((ResourceLocation)ToLaserBlade.makeId("item/parts/lb_casing")), modelOutput), (ItemTintSource[])new ItemTintSource[]{new LaserBladeTintSource(LaserBladeColorPart.GRIP)});
        itemModelOutput.accept(ModItems.LB_CASING, vanillaCasingModel);
        itemModelOutput.accept(ModItems.LB_CASING_FP, vanillaCasingModel);
        ItemModel.Unbaked specialCasingModel = ItemModelUtils.specialModel((ResourceLocation)this.createLBSwordModel(ModelLocationUtils.getModelLocation((Item)ModItems.LB_CASING, (String)"_3d"), LBSwordItemTransforms.ITEM_TRANSFORMS, modelOutput), (SpecialModelRenderer.Unbaked)new LBSwordSpecialRenderer.Unbaked());
        ItemModel.Unbaked suspendedLBModel = ItemModelUtils.conditional((ConditionalItemModelProperty)new UsingOriginalModel(), (ItemModel.Unbaked)specialCasingModel, (ItemModel.Unbaked)vanillaCasingModel);
        itemModelOutput.accept(ModItems.LB_BRAND_NEW, suspendedLBModel);
        itemModelOutput.accept(ModItems.LB_BRAND_NEW_1, suspendedLBModel);
        itemModelOutput.accept(ModItems.LB_BRAND_NEW_2, suspendedLBModel);
        itemModelOutput.accept(ModItems.LB_BRAND_NEW_FP, suspendedLBModel);
        itemModelOutput.accept(ModItems.LB_BROKEN, suspendedLBModel);
        itemModelOutput.accept(ModItems.LB_BROKEN_FP, suspendedLBModel);
        ItemModel.Unbaked DisassembledLBModel = ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)ModItems.LB_DISASSEMBLED), TextureMapping.layer0((ResourceLocation)ToLaserBlade.makeId("item/parts/lb_disassembled")), modelOutput));
        itemModelOutput.accept(ModItems.LB_DISASSEMBLED, DisassembledLBModel);
        itemModelOutput.accept(ModItems.LB_DISASSEMBLED_FP, DisassembledLBModel);
    }

    private ItemModel.Unbaked generateLBSwordModel(Item item, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        ItemModel.Unbaked blockingLeft = ItemModelUtils.specialModel((ResourceLocation)this.createLBSwordModel(ModelLocationUtils.getModelLocation((Item)item, (String)"_blocking_left"), LBSwordItemTransforms.BLOCKING_LEFT_ITEM_TRANSFORMS, modelOutput), (SpecialModelRenderer.Unbaked)new LBSwordSpecialRenderer.Unbaked());
        ItemModel.Unbaked blockingRight = ItemModelUtils.specialModel((ResourceLocation)this.createLBSwordModel(ModelLocationUtils.getModelLocation((Item)item, (String)"_blocking_right"), LBSwordItemTransforms.BLOCKING_RIGHT_ITEM_TRANSFORMS, modelOutput), (SpecialModelRenderer.Unbaked)new LBSwordSpecialRenderer.Unbaked());
        ItemModel.Unbaked blockingModel = ItemModelUtils.select((SelectItemModelProperty)new MainHand(), (ItemModel.Unbaked)blockingRight, (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when((Object)HumanoidArm.LEFT, (ItemModel.Unbaked)blockingLeft)});
        ItemModel.Unbaked defaultModel = ItemModelUtils.specialModel((ResourceLocation)this.createLBSwordModel(ModelLocationUtils.getModelLocation((Item)item, (String)""), LBSwordItemTransforms.ITEM_TRANSFORMS, modelOutput), (SpecialModelRenderer.Unbaked)new LBSwordSpecialRenderer.Unbaked());
        ItemModel.Unbaked specialModel = ItemModelUtils.conditional((ConditionalItemModelProperty)new Blocking(), (ItemModel.Unbaked)blockingModel, (ItemModel.Unbaked)defaultModel);
        ModelTemplate threeLayeredHandheldItem = ModelTemplates.createItem((String)"handheld", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2});
        ItemModel.Unbaked vanillaModel = ItemModelUtils.tintedModel((ResourceLocation)threeLayeredHandheldItem.create(ModelLocationUtils.getModelLocation((Item)item, (String)"_2d"), TextureMapping.layered((ResourceLocation)ToLaserBlade.makeId("item/laser_blade_2d_0"), (ResourceLocation)ToLaserBlade.makeId("item/laser_blade_2d_1"), (ResourceLocation)ToLaserBlade.makeId("item/laser_blade_2d_2")), modelOutput), (ItemTintSource[])new ItemTintSource[]{new LaserBladeTintSource(LaserBladeColorPart.GRIP), new LaserBladeTintSource(LaserBladeColorPart.OUTER_BLADE), new LaserBladeTintSource(LaserBladeColorPart.INNER_BLADE)});
        return ItemModelUtils.conditional((ConditionalItemModelProperty)new UsingOriginalModel(), (ItemModel.Unbaked)specialModel, (ItemModel.Unbaked)vanillaModel);
    }

    private ResourceLocation createLBSwordModel(ResourceLocation location, LBSwordItemTransforms transforms, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        modelOutput.accept(location, () -> new Gson().toJsonTree((Object)new LBSwordModel(ResourceLocation.withDefaultNamespace((String)"item/iron_ingot"), transforms.get())));
        return location;
    }

    public static class LBSwordModel {
        @SerializedName(value="gui_light")
        public String guiLight = "front";
        public Map<String, String> textures = new HashMap<String, String>();
        public Map<String, Map<String, float[]>> display = new HashMap<String, Map<String, float[]>>();

        public LBSwordModel(ResourceLocation particle, ItemTransforms itemTransforms) {
            this.textures.put("particle", particle.toString());
            Arrays.stream(ItemDisplayContext.values()).forEach(c -> this.addTransform(c.getSerializedName(), itemTransforms.getTransform(c)));
        }

        private void addTransform(String displayContext, ItemTransform itemTransform) {
            Vector3fc v;
            HashMap<String, float[]> transform = new HashMap<String, float[]>();
            if (!ItemTransform.NO_TRANSFORM.scale().equals((Object)itemTransform.scale())) {
                v = itemTransform.scale();
                transform.put("scale", new float[]{v.x(), v.y(), v.z()});
            }
            if (!ItemTransform.NO_TRANSFORM.rotation().equals((Object)itemTransform.rotation())) {
                v = itemTransform.rotation();
                transform.put("rotation", new float[]{v.x(), v.y(), v.z()});
            }
            if (!ItemTransform.NO_TRANSFORM.translation().equals((Object)itemTransform.translation())) {
                v = itemTransform.translation();
                transform.put("translation", new float[]{v.x() * 16.0f, v.y() * 16.0f, v.z() * 16.0f});
            }
            if (!transform.isEmpty()) {
                this.display.put(displayContext, transform);
            }
        }
    }
}

