/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.data;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.data.TLBBlockTagsProvider;
import com.github.iunius118.tolaserblade.tags.ModItemTags;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagCopyingItemTagProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;

public class TLBOldRecipeProvider6 {
    public static final String PACK_PATH = "old_lb_recipes_6";
    public static final ResourceLocation PACK_ID = ToLaserBlade.makeId("old_lb_recipes_6");
    public static final String PACK_TITLE = "old_lb_recipes_6";
    public static final String PACK_DESCRIPTION = "ToLaserBlade - revert laser blade recipes to version 6";

    private TLBOldRecipeProvider6() {
    }

    public static void addProviders(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = new PackOutput(dataGenerator.getPackOutput().getOutputFolder().resolve("old_lb_recipes_6"));
        CompletableFuture lookupProvider = event.getLookupProvider();
        TLBBlockTagsProvider blockTagsProvider = new TLBBlockTagsProvider(packOutput, lookupProvider);
        DataGenerator.PackGenerator packGenerator = dataGenerator.getBuiltinDatapack(true, "old_lb_recipes_6");
        packGenerator.addProvider(o -> PackMetadataGenerator.forFeaturePack((PackOutput)packOutput, (Component)Component.literal((String)PACK_DESCRIPTION)));
        packGenerator.addProvider(o -> new OldRecipeProvider.Runner(packOutput, lookupProvider));
        packGenerator.addProvider(o -> blockTagsProvider);
        packGenerator.addProvider(o -> new OldItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter()));
    }

    public static void addPackFinders(AddPackFindersEvent event) {
        event.addPackFinders(PACK_ID, PackType.SERVER_DATA, (Component)Component.literal((String)"old_lb_recipes_6"), PackSource.FEATURE, false, Pack.Position.TOP);
    }

    public static class OldItemTagsProvider
    extends BlockTagCopyingItemTagProvider {
        private Set<ResourceLocation> filter = null;

        public OldItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider) {
            super(packOutput, lookupProvider, blockTagProvider, "tolaserblade");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.filter = new HashSet(this.builders.keySet());
            this.tag(ModItemTags.ATTACK_DAMAGE_UPGRADE).replace().addTags(new TagKey[]{Tags.Items.GEMS_DIAMOND});
        }

        protected Path getPath(ResourceLocation id) {
            return this.filter != null && this.filter.contains(id) ? null : super.getPath(id);
        }
    }

    private static class OldRecipeProvider
    extends VanillaRecipeProvider {
        public OldRecipeProvider(HolderLookup.Provider registryLookup, RecipeOutput output) {
            super(registryLookup, output);
        }

        protected void buildRecipes() {
            HolderLookup.RegistryLookup holderGetter = this.registries.lookupOrThrow(Registries.ITEM);
            ShapedRecipeBuilder.shaped((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.LB_BRAND_NEW_1).pattern("Gid").pattern("idi").pattern("riG").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_redstone", this.has((ItemLike)Items.REDSTONE)).save(this.output, String.valueOf(this.getItemId(ModItems.LB_BRAND_NEW_1)) + "_v_6");
            ShapedRecipeBuilder.shaped((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.LB_BRAND_NEW_2).pattern("gid").pattern("idi").pattern("rig").define(Character.valueOf('g'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_redstone", this.has((ItemLike)Items.REDSTONE)).save(this.output, String.valueOf(this.getItemId(ModItems.LB_BRAND_NEW_2)) + "_v_6");
        }

        private ResourceLocation getItemId(Item item) {
            return BuiltInRegistries.ITEM.getKey((Object)item);
        }

        public static class Runner
        extends RecipeProvider.Runner {
            public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
                super(output, registries);
            }

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider registryLookup, RecipeOutput exporter) {
                return new OldRecipeProvider(registryLookup, exporter);
            }

            public String getName() {
                return "Recipes";
            }
        }
    }
}

