/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.data;

import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeColor;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeColorPart;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrade;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeID;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeManager;
import com.github.iunius118.tolaserblade.data.recipes.LBColorRecipeBuilder;
import com.github.iunius118.tolaserblade.data.recipes.LBModelChangeRecipeBuilder;
import com.github.iunius118.tolaserblade.data.recipes.LBUpgradeRecipeBuilder;
import com.github.iunius118.tolaserblade.tags.ModItemTags;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class TLBRecipeProvider
extends VanillaRecipeProvider {
    public TLBRecipeProvider(HolderLookup.Provider registryLookup, RecipeOutput output) {
        super(registryLookup, output);
    }

    public void buildRecipes() {
        this.buildCraftingRecipes();
        this.buildSmithingRecipes();
    }

    public void buildCraftingRecipes() {
        HolderLookup.RegistryLookup holderGetter = this.registries.lookupOrThrow(Registries.ITEM);
        ShapedRecipeBuilder.shaped((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)ModItems.DX_LASER_BLADE).pattern("R").pattern("R").pattern("s").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_redstone", this.has((ItemLike)Items.REDSTONE)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.LB_BLUEPRINT).requires((ItemLike)ModItems.DX_LASER_BLADE).requires((ItemLike)Items.PAPER).requires(Tags.Items.DYES_BLUE).unlockedBy("has_redstone", this.has((ItemLike)Items.REDSTONE)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.LB_BATTERY).pattern("#").pattern("i").pattern("r").define(Character.valueOf('#'), (ItemLike)ModItems.LB_BLUEPRINT).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_lb_blueprint", this.has((ItemLike)ModItems.LB_BLUEPRINT)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.LB_MEDIUM).pattern(" # ").pattern("gdg").define(Character.valueOf('#'), (ItemLike)ModItems.LB_BLUEPRINT).define(Character.valueOf('g'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).unlockedBy("has_lb_blueprint", this.has((ItemLike)ModItems.LB_BLUEPRINT)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.LB_EMITTER).pattern("#").pattern("d").pattern("i").define(Character.valueOf('#'), (ItemLike)ModItems.LB_BLUEPRINT).define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).unlockedBy("has_lb_blueprint", this.has((ItemLike)ModItems.LB_BLUEPRINT)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.LB_CASING).pattern("#").pattern("i").pattern("i").define(Character.valueOf('#'), (ItemLike)ModItems.LB_BLUEPRINT).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).unlockedBy("has_lb_blueprint", this.has((ItemLike)ModItems.LB_BLUEPRINT)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)ModItems.LB_BRAND_NEW_1).requires((ItemLike)ModItems.LB_BLUEPRINT).requires((ItemLike)ModItems.LB_BATTERY).requires(Tags.Items.GEMS_DIAMOND).requires(Tags.Items.GLASS_BLOCKS_COLORLESS).requires((ItemLike)ModItems.LB_EMITTER).requires((ItemLike)ModItems.LB_CASING).unlockedBy("has_lb_blueprint", this.has((ItemLike)ModItems.LB_BLUEPRINT)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)holderGetter, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)ModItems.LB_BRAND_NEW_2).requires((ItemLike)ModItems.LB_BLUEPRINT).requires((ItemLike)ModItems.LB_BATTERY).requires((ItemLike)ModItems.LB_MEDIUM).requires((ItemLike)ModItems.LB_EMITTER).requires((ItemLike)ModItems.LB_CASING).unlockedBy("has_lb_blueprint", this.has((ItemLike)ModItems.LB_BLUEPRINT)).save(this.output);
    }

    public void buildSmithingRecipes() {
        Ingredient template = Ingredient.of((ItemLike)ModItems.LB_BLUEPRINT);
        this.addSmithingRepairRecipe("lbb", template, ModItems.LB_BROKEN, this.getIngredient(ModItemTags.CASING_REPAIR), ModItems.LB_BRAND_NEW, ModItems.LB_BROKEN);
        this.addSmithingRepairRecipe("lbbf", template, ModItems.LB_BROKEN_FP, this.getIngredient(ModItemTags.CASING_REPAIR), ModItems.LB_BRAND_NEW_FP, ModItems.LB_BROKEN_FP);
        this.addUpgradeRecipes(template);
        this.addColorRecipes(template);
        this.addModelChangeRecipes(template, Ingredient.of((ItemLike)Blocks.GLASS.asItem()), 0, "");
        this.addModelChangeRecipes(template, Ingredient.of((ItemLike)Blocks.SAND.asItem()), 1, "");
        this.addModelChangeRecipes(template, Ingredient.of((ItemLike)Blocks.SANDSTONE.asItem()), 2, "");
        this.addModelChangeRecipes(template, Ingredient.of((ItemLike)Blocks.DIRT.asItem()), 526, "");
    }

    private void addSmithingTransformRecipe(Ingredient template, Ingredient base, Ingredient addition, Item result, Item criterionItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)template, (Ingredient)base, (Ingredient)addition, (RecipeCategory)RecipeCategory.TOOLS, (Item)result).unlocks("has_" + this.getItemId(criterionItem).getPath(), this.has((ItemLike)criterionItem)).save(this.output, this.getItemId(result).toString() + "_smithing");
    }

    private void addSmithingRepairRecipe(String shortName, Ingredient template, Item base, Ingredient addition, Item result, Item criterionItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)template, (Ingredient)Ingredient.of((ItemLike)base), (Ingredient)addition, (RecipeCategory)RecipeCategory.TOOLS, (Item)result).unlocks("has_" + this.getItemId(criterionItem).getPath(), this.has((ItemLike)criterionItem)).save(this.output, "tolaserblade:repair_" + shortName + "_smithing");
    }

    private void addUpgradeRecipes(Ingredient template) {
        Map<ResourceLocation, Upgrade> upgrades = UpgradeManager.getUpgrades();
        upgrades.forEach((id, upgrade) -> {
            TagKey<Item> tag = upgrade.ingredientItemTag();
            Ingredient ingredient = Ingredient.of((HolderSet)this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(tag));
            LBUpgradeRecipeBuilder.upgradeRecipe(template, Ingredient.of((ItemLike)ModItems.LASER_BLADE), ingredient, RecipeCategory.TOOLS, id).unlockedBy("has_laser_blade", this.has((ItemLike)ModItems.LASER_BLADE)).save(this.output, "tolaserblade:upgrade/lb_" + upgrade.shortName());
            if (upgrade == UpgradeManager.getUpgrade(UpgradeID.FIREPROOF_UPGRADE)) {
                return;
            }
            LBUpgradeRecipeBuilder.upgradeRecipe(template, Ingredient.of((ItemLike)ModItems.LASER_BLADE_FP), ingredient, RecipeCategory.TOOLS, id).unlockedBy("has_laser_blade_fp", this.has((ItemLike)ModItems.LASER_BLADE_FP)).save(this.output, "tolaserblade:upgrade/lbf_" + upgrade.shortName());
        });
    }

    private void addColorRecipes(Ingredient template) {
        this.addInnerColorRecipes(template);
        this.addOuterColorRecipes(template);
        this.addGripColorRecipes(template);
    }

    private void addInnerColorRecipes(Ingredient template) {
        LaserBladeColorPart part = LaserBladeColorPart.INNER_BLADE;
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.WHITE_STAINED_GLASS_PANE), part, LaserBladeColor.WHITE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.ORANGE_STAINED_GLASS_PANE), part, LaserBladeColor.ORANGE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.MAGENTA_STAINED_GLASS_PANE), part, LaserBladeColor.MAGENTA);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.LIGHT_BLUE_STAINED_GLASS_PANE), part, LaserBladeColor.LIGHT_BLUE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.YELLOW_STAINED_GLASS_PANE), part, LaserBladeColor.YELLOW);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.LIME_STAINED_GLASS_PANE), part, LaserBladeColor.LIME);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.PINK_STAINED_GLASS_PANE), part, LaserBladeColor.PINK);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.GRAY_STAINED_GLASS_PANE), part, LaserBladeColor.GRAY);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.LIGHT_GRAY_STAINED_GLASS_PANE), part, LaserBladeColor.LIGHT_GRAY);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.CYAN_STAINED_GLASS_PANE), part, LaserBladeColor.CYAN);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.PURPLE_STAINED_GLASS_PANE), part, LaserBladeColor.PURPLE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.BLUE_STAINED_GLASS_PANE), part, LaserBladeColor.BLUE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.BROWN_STAINED_GLASS_PANE), part, LaserBladeColor.BROWN);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.GREEN_STAINED_GLASS_PANE), part, LaserBladeColor.GREEN);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.RED_STAINED_GLASS_PANE), part, LaserBladeColor.RED);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.BLACK_STAINED_GLASS_PANE), part, LaserBladeColor.BLACK);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.AMETHYST_BLOCK), part, LaserBladeColor.SPECIAL_SWITCH_BLEND_MODE);
    }

    private void addOuterColorRecipes(Ingredient template) {
        LaserBladeColorPart part = LaserBladeColorPart.OUTER_BLADE;
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.WHITE_STAINED_GLASS), part, LaserBladeColor.WHITE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.ORANGE_STAINED_GLASS), part, LaserBladeColor.ORANGE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.MAGENTA_STAINED_GLASS), part, LaserBladeColor.MAGENTA);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.LIGHT_BLUE_STAINED_GLASS), part, LaserBladeColor.LIGHT_BLUE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.YELLOW_STAINED_GLASS), part, LaserBladeColor.YELLOW);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.LIME_STAINED_GLASS), part, LaserBladeColor.LIME);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.PINK_STAINED_GLASS), part, LaserBladeColor.PINK);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.GRAY_STAINED_GLASS), part, LaserBladeColor.GRAY);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.LIGHT_GRAY_STAINED_GLASS), part, LaserBladeColor.LIGHT_GRAY);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.CYAN_STAINED_GLASS), part, LaserBladeColor.CYAN);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.PURPLE_STAINED_GLASS), part, LaserBladeColor.PURPLE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.BLUE_STAINED_GLASS), part, LaserBladeColor.BLUE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.BROWN_STAINED_GLASS), part, LaserBladeColor.BROWN);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.GREEN_STAINED_GLASS), part, LaserBladeColor.GREEN);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.RED_STAINED_GLASS), part, LaserBladeColor.RED);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Items.BLACK_STAINED_GLASS), part, LaserBladeColor.BLACK);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.TINTED_GLASS), part, LaserBladeColor.SPECIAL_SWITCH_BLEND_MODE);
    }

    private void addGripColorRecipes(Ingredient template) {
        LaserBladeColorPart part = LaserBladeColorPart.GRIP;
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.WHITE_CARPET), part, LaserBladeColor.WHITE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.ORANGE_CARPET), part, LaserBladeColor.ORANGE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.MAGENTA_CARPET), part, LaserBladeColor.MAGENTA);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.LIGHT_BLUE_CARPET), part, LaserBladeColor.LIGHT_BLUE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.YELLOW_CARPET), part, LaserBladeColor.YELLOW);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.LIME_CARPET), part, LaserBladeColor.LIME);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.PINK_CARPET), part, LaserBladeColor.PINK);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.GRAY_CARPET), part, LaserBladeColor.GRAY);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.LIGHT_GRAY_CARPET), part, LaserBladeColor.LIGHT_GRAY);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.CYAN_CARPET), part, LaserBladeColor.CYAN);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.PURPLE_CARPET), part, LaserBladeColor.PURPLE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.BLUE_CARPET), part, LaserBladeColor.BLUE);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.BROWN_CARPET), part, LaserBladeColor.BROWN);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.GREEN_CARPET), part, LaserBladeColor.GREEN);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.RED_CARPET), part, LaserBladeColor.RED);
        this.addColorRecipe(template, Ingredient.of((ItemLike)Blocks.BLACK_CARPET), part, LaserBladeColor.BLACK);
    }

    private void addColorRecipe(Ingredient template, Ingredient addition, LaserBladeColorPart part, LaserBladeColor color) {
        int colorValue = switch (part) {
            case LaserBladeColorPart.OUTER_BLADE -> color.getOuterColor();
            case LaserBladeColorPart.INNER_BLADE -> color.getInnerColor();
            default -> color.getGripColor();
        };
        LBColorRecipeBuilder.colorRecipe(template, Ingredient.of((ItemLike)ModItems.LASER_BLADE), addition, RecipeCategory.TOOLS, part, colorValue).unlockedBy("has_laser_blade", this.has((ItemLike)ModItems.LASER_BLADE)).save(this.output, "tolaserblade:color/lb_" + part.getShortName() + "_" + color.getColorName());
        LBColorRecipeBuilder.colorRecipe(template, Ingredient.of((ItemLike)ModItems.LASER_BLADE_FP), addition, RecipeCategory.TOOLS, part, colorValue).unlockedBy("has_laser_blade_fp", this.has((ItemLike)ModItems.LASER_BLADE_FP)).save(this.output, "tolaserblade:color/lbf_" + part.getShortName() + "_" + color.getColorName());
    }

    private void addModelChangeRecipes(Ingredient template, Ingredient addition, int modelType, String suffixIn) {
        String suffix = suffixIn == null ? "" : suffixIn;
        LBModelChangeRecipeBuilder.modelChangeRecipe(template, Ingredient.of((ItemLike)ModItems.LASER_BLADE), addition, RecipeCategory.TOOLS, modelType).unlockedBy("has_laser_blade", this.has((ItemLike)ModItems.LASER_BLADE)).save(this.output, "tolaserblade:model/lb_" + modelType + suffix);
        LBModelChangeRecipeBuilder.modelChangeRecipe(template, Ingredient.of((ItemLike)ModItems.LASER_BLADE_FP), addition, RecipeCategory.TOOLS, modelType).unlockedBy("has_laser_blade_fp", this.has((ItemLike)ModItems.LASER_BLADE_FP)).save(this.output, "tolaserblade:model/lbf_" + modelType + suffix);
    }

    private ResourceLocation getItemId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    private Ingredient getIngredient(TagKey<Item> tag) {
        return Ingredient.of((HolderSet)this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(tag));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registryLookup, RecipeOutput exporter) {
            return new TLBRecipeProvider(registryLookup, exporter);
        }

        public String getName() {
            return "Recipes";
        }
    }
}

