/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.data;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.common.util.ModSoundEvents;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;

public class TLBSampleSoundPackProvider {
    public static final String PACK_PATH = "sample_sound_pack";
    public static final ResourceLocation PACK_ID = ToLaserBlade.makeId("sample_sound_pack");
    public static final String PACK_TITLE = "TLB Sample Sound Pack";
    public static final String PACK_DESCRIPTION = "ToLaserBlade - sample sound pack for laser blade";

    private TLBSampleSoundPackProvider() {
    }

    public static void addProviders(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = new PackOutput(dataGenerator.getPackOutput().getOutputFolder().resolve(PACK_PATH));
        DataGenerator.PackGenerator packGenerator = dataGenerator.getBuiltinDatapack(true, PACK_PATH);
        PackMetadataSection packMetadataSection = new PackMetadataSection((Component)Component.literal((String)PACK_DESCRIPTION), DetectedVersion.BUILT_IN.packVersion(PackType.CLIENT_RESOURCES).minorRange());
        packGenerator.addProvider(o -> new PackMetadataGenerator(packOutput).add(PackMetadataSection.CLIENT_TYPE, (Object)packMetadataSection));
        packGenerator.addProvider(o -> new SampleSoundDefinitionsProvider(packOutput));
    }

    public static void addPackFinders(AddPackFindersEvent event) {
        event.addPackFinders(PACK_ID, PackType.CLIENT_RESOURCES, (Component)Component.literal((String)PACK_TITLE), PackSource.BUILT_IN, false, Pack.Position.TOP);
    }

    private static class SampleSoundDefinitionsProvider
    extends SoundDefinitionsProvider {
        public SampleSoundDefinitionsProvider(PackOutput packOutput) {
            super(packOutput, "tolaserblade");
        }

        public void registerSounds() {
            float[] pitch1 = new float[]{1.0f, 1.025f, 1.05f, 1.075f, 1.1f};
            float[] pitch2 = new float[]{1.0f, 1.1f, 1.2f, 1.3f, 1.4f};
            this.addSingleFileSound(ModSoundEvents.ITEM_DX_LASER_BLADE_SWING, true, pitch1);
            this.addSingleFileSound(ModSoundEvents.ITEM_LASER_BLADE_SWING, true, pitch1);
            this.addSingleFileSound(ModSoundEvents.ITEM_LASER_BLADE_FP_SWING, true, pitch1);
            this.addSingleFileSound(ModSoundEvents.ITEM_DX_LASER_BLADE_HIT, true, pitch2);
            this.addSingleFileSound(ModSoundEvents.ITEM_LASER_BLADE_HIT, true, pitch2);
            this.addSingleFileSound(ModSoundEvents.ITEM_LASER_BLADE_FP_HIT, true, pitch2);
            this.addSingleFileSound(ModSoundEvents.ITEM_LASER_BLADE_BLOCK, true, pitch1);
            this.addSingleFileSound(ModSoundEvents.ITEM_LASER_BLADE_FP_BLOCK, true, pitch1);
            this.addSingleFileSound(ModSoundEvents.ITEM_LASER_TRAP_ACTIVATE, true, pitch2);
            this.addSingleFileSound(ModSoundEvents.ITEM_LB_BRAND_NEW_USE, true, pitch2);
            this.addSingleFileSound(ModSoundEvents.ITEM_LB_BRAND_NEW_FP_USE, true, pitch2);
        }

        private void addSingleFileSound(SoundEvent soundEvent) {
            SoundDefinition soundDefinition = SampleSoundDefinitionsProvider.definition().with(this.getSound(soundEvent.location()));
            this.add(soundEvent, soundDefinition);
        }

        private void addSingleFileSound(SoundEvent soundEvent, boolean replace) {
            SoundDefinition soundDefinition = SampleSoundDefinitionsProvider.definition().with(this.getSound(soundEvent.location()));
            if (replace) {
                soundDefinition.replace(true);
            }
            this.add(soundEvent, soundDefinition);
        }

        private void addSingleFileSound(SoundEvent soundEvent, boolean replace, float[] pitchArray) {
            SoundDefinition soundDefinition = SampleSoundDefinitionsProvider.definition();
            for (float pitch : pitchArray) {
                soundDefinition.with(this.getSound(soundEvent.location()).pitch(pitch));
            }
            if (replace) {
                soundDefinition.replace(true);
            }
            this.add(soundEvent, soundDefinition);
        }

        private SoundDefinition.Sound getSound(ResourceLocation location) {
            return SampleSoundDefinitionsProvider.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)location.getPath().replace(".", "/")));
        }
    }
}

