/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.data.recipes;

import com.github.iunius118.tolaserblade.world.item.crafting.LBUpgradeRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class LBUpgradeRecipeBuilder {
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient addition;
    private final RecipeCategory category;
    private final ResourceLocation upgradeId;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public LBUpgradeRecipeBuilder(Ingredient template, Ingredient base, Ingredient addition, RecipeCategory category, ResourceLocation upgradeId) {
        this.category = category;
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.upgradeId = upgradeId;
    }

    public static LBUpgradeRecipeBuilder upgradeRecipe(Ingredient template, Ingredient base, Ingredient addition, RecipeCategory category, ResourceLocation upgradeId) {
        return new LBUpgradeRecipeBuilder(template, base, addition, category, upgradeId);
    }

    public LBUpgradeRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public void save(RecipeOutput output, String id) {
        this.save(output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)id)));
    }

    public void save(RecipeOutput output, ResourceKey<Recipe<?>> id) {
        ResourceLocation location = id.location();
        this.ensureValid(location);
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(id)).rewards(AdvancementRewards.Builder.recipe(id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        LBUpgradeRecipe recipe = new LBUpgradeRecipe(Optional.of(this.template), this.base, Optional.of(this.addition), this.upgradeId);
        output.accept(id, (Recipe)recipe, advancementBuilder.build(location.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }
}

