/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.world.item.DXLaserBladeItemUtil;
import com.github.iunius118.tolaserblade.world.item.ModToolMaterials;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class DXLaserBladeItem
extends Item {
    public DXLaserBladeItem(Item.Properties properties) {
        super(properties.sword(ModToolMaterials.DX_LASER_BLADE, 3.0f, -1.2f));
    }

    public void hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        if (!level.isClientSide() && attacker instanceof Player) {
            DXLaserBladeItemUtil.playSwingSound(level, attacker);
        }
        super.hurtEnemy(stack, target, attacker);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Level level = entity.level();
        if (!level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.swinging) {
                DXLaserBladeItemUtil.playSwingSound(level, entity);
            }
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        return DXLaserBladeItemUtil.useOn(context);
    }
}

