/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.common.util.ModSoundEvents;
import com.github.iunius118.tolaserblade.world.item.ModToolMaterials;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DXLaserBladeItemUtil {
    public static InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        BlockPos blockPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        int costDamage = ModToolMaterials.DX_LASER_BLADE.durability() / 2 + 1;
        if ((block == Blocks.REDSTONE_TORCH || block == Blocks.REDSTONE_WALL_TORCH) && player.mayUseItemAt(blockPos, direction, itemStack)) {
            return DXLaserBladeItemUtil.removeRedstoneTorch(context, costDamage);
        }
        return DXLaserBladeItemUtil.placeRedstoneTorch(context, costDamage);
    }

    private static InteractionResult removeRedstoneTorch(UseOnContext context, int costDamage) {
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        int itemDamage = itemStack.getDamageValue();
        if (itemDamage >= costDamage || player.getAbilities().instabuild) {
            itemStack.setDamageValue(itemDamage - costDamage);
        } else if (!player.getInventory().add(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH))) {
            return InteractionResult.PASS;
        }
        return DXLaserBladeItemUtil.destroyRedstoneTorch(context);
    }

    private static InteractionResult destroyRedstoneTorch(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        BlockState blockState = level.getBlockState(blockPos);
        blockState.getBlock().playerWillDestroy(level, blockPos, blockState, player);
        blockState.onDestroyedByPlayer(level, blockPos, player, itemStack, false, level.getFluidState(blockPos));
        return InteractionResult.SUCCESS;
    }

    private static InteractionResult placeRedstoneTorch(UseOnContext context, int costDamage) {
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        if (!player.getAbilities().instabuild && itemStack.getDamageValue() >= costDamage) {
            return InteractionResult.PASS;
        }
        BlockPos blockPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        ItemStack redstoneTorch = new ItemStack((ItemLike)Blocks.REDSTONE_TORCH);
        BlockPlaceContext contextRS = new BlockPlaceContext(player, context.getHand(), redstoneTorch, new BlockHitResult(context.getClickLocation(), direction, blockPos, context.isInside()));
        if (player.isSteppingCarefully() && redstoneTorch.useOn((UseOnContext)contextRS).consumesAction()) {
            itemStack.setCount(1);
            itemStack.hurtAndBreak(costDamage, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void playSwingSound(Level level, LivingEntity entity) {
        Vec3 pos = entity.position();
        level.playSound(null, pos.x, pos.y, pos.z, ModSoundEvents.ITEM_DX_LASER_BLADE_SWING, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void playHitSound(Level level, Entity target, ItemStack itemStack) {
        Vec3 pos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
        level.playSound(null, pos.x, pos.y, pos.z, ModSoundEvents.ITEM_DX_LASER_BLADE_HIT, target.getSoundSource(), 1.0f, 1.0f);
    }

    private DXLaserBladeItemUtil() {
    }
}

