/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.world.item.DXLaserBladeItem;
import com.github.iunius118.tolaserblade.world.item.DXLaserBladeItemUtil;
import com.github.iunius118.tolaserblade.world.item.LBSwordItem;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemUtil;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ItemEventHandler {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.getItem() == ModItems.LASER_BLADE || itemStack.getItem() == ModItems.LASER_BLADE_FP) {
            ItemStack itemStack1;
            event.setCanceled(true);
            Player player = event.getEntity();
            ItemStack itemStack2 = itemStack1 = itemStack.isEmpty() ? ItemStack.EMPTY : itemStack.copy();
            if (event.getTarget().interact(event.getEntity(), event.getHand()).consumesAction()) {
                if (player.getAbilities().instabuild && itemStack == event.getItemStack() && itemStack.getCount() < itemStack1.getCount()) {
                    itemStack.setCount(itemStack1.getCount());
                }
                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                return;
            }
            event.setCancellationResult((InteractionResult)InteractionResult.PASS);
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        ItemStack stack = event.getEntity().getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof LBSwordItem) {
            LBSwordItem lbSwordItem = (LBSwordItem)item;
            lbSwordItem.onCriticalHit(event);
        }
    }

    @SubscribeEvent
    public static void onMineBlock(PlayerEvent.BreakSpeed event) {
        LaserBladeItemUtil.changeDestroySpeed(event);
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide() || player.isSpectator()) {
            return;
        }
        Entity target = event.getTarget();
        ItemStack itemStack = player.getMainHandItem();
        Item item = itemStack.getItem();
        if (item instanceof LBSwordItem) {
            LaserBladeItemUtil.playHitSound(level, target, itemStack);
        } else if (item instanceof DXLaserBladeItem) {
            DXLaserBladeItemUtil.playHitSound(level, target, itemStack);
        }
    }
}

