/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.common.util.ModSoundEvents;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrade;
import com.github.iunius118.tolaserblade.world.item.LBBrandNewType;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemStack;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public class LBBrandNewItem
extends Item
implements LaserBladeItemBase {
    private final LBBrandNewType type;

    public LBBrandNewItem(Item.Properties properties, LBBrandNewType typeIn) {
        super(properties);
        this.type = typeIn;
    }

    @Override
    public boolean canUpgrade(Upgrade.Type type) {
        return false;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            this.setLaserBladeToPlayer(level, player, hand, itemStack);
            LBBrandNewItem.playUseSound(level, (LivingEntity)player, this.type == LBBrandNewType.FP);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private void setLaserBladeToPlayer(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
        ItemStack laserBladeStack;
        if (this.type == LBBrandNewType.NONE || this.type == LBBrandNewType.FP) {
            laserBladeStack = itemStack.transmuteCopy((ItemLike)this.type.getCopy((HolderLookup.Provider)level.registryAccess()).getItem(), itemStack.getCount());
            laserBladeStack.setDamageValue(0);
        } else {
            laserBladeStack = this.getPresetLaserBlade(level, player, itemStack);
        }
        if (player.getAbilities().instabuild) {
            player.addItem(laserBladeStack);
            return;
        }
        if (itemStack.getCount() > 1) {
            if (player.addItem(laserBladeStack)) {
                itemStack.shrink(1);
            }
            return;
        }
        EquipmentSlot slotType = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        player.setItemSlot(slotType, laserBladeStack);
    }

    private ItemStack getPresetLaserBlade(Level level, Player player, ItemStack brandNewStack) {
        String name;
        Component customName = (Component)brandNewStack.get(DataComponents.CUSTOM_NAME);
        String string = name = customName != null ? customName.getString() : "";
        if ("GIFT".equals(name) || "\u304a\u305f\u304b\u3089".equals(name)) {
            return LaserBladeItemStack.GIFT.getCopy((HolderLookup.Provider)level.registryAccess());
        }
        ItemStack laserBladeStack = this.type.getCopy((HolderLookup.Provider)level.registryAccess());
        BlockPos pos = player.blockPosition();
        Holder biome = level.getBiome(pos);
        LaserBladeAppearance appearance = LaserBladeAppearance.of().setColorsByBiome(level, (Holder<Biome>)biome);
        try {
            int modelType = Integer.parseInt(name);
            appearance.setType(modelType);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        appearance.setTo(laserBladeStack);
        return laserBladeStack;
    }

    public static void playUseSound(Level level, LivingEntity entity, boolean isFireResistant) {
        SoundEvent soundEvent = isFireResistant ? ModSoundEvents.ITEM_LB_BRAND_NEW_FP_USE : ModSoundEvents.ITEM_LB_BRAND_NEW_USE;
        Vec3 pos = entity.position();
        level.playSound(null, pos.x, pos.y, pos.z, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipFlag flag, List<Component> tooltip) {
        ArrayList<Component> myTooltip = new ArrayList<Component>();
        LaserBladeItemUtil.addBrandNewText(myTooltip);
        LaserBladeItemUtil.addLaserBladeInformation(itemStack, tooltipContext, myTooltip, flag, Upgrade.Type.REPAIR);
        tooltip.addAll(1, myTooltip);
    }
}

