/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.core.laserblade.LaserBlade;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrade;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemUtil;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LBDisassembledItem
extends Item
implements LaserBladeItemBase {
    public final Upgrade.Type upgradeType = Upgrade.Type.REPAIR;

    public LBDisassembledItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean canUpgrade(Upgrade.Type type) {
        return false;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            this.disassembleLaserBlade(level, player, itemStack);
            itemStack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    private void disassembleLaserBlade(Level level, Player player, ItemStack itemStack) {
        ItemStack batteryStack = new ItemStack((ItemLike)ModItems.LB_BATTERY);
        ItemStack mediumStack = new ItemStack((ItemLike)ModItems.LB_MEDIUM);
        ItemStack emitterStack = new ItemStack((ItemLike)ModItems.LB_EMITTER);
        ItemStack casingStack = new ItemStack((ItemLike)(LaserBladeItemUtil.isFireResistant(itemStack) ? ModItems.LB_CASING_FP : ModItems.LB_CASING));
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
        LaserBlade.setSpeed(batteryStack, LaserBlade.getSpeed(itemStack));
        LaserBlade.setAttack(mediumStack, LaserBlade.getAttack(itemStack));
        enchantments.keySet().forEach(e -> {
            if (e.unwrapKey().isEmpty()) {
                return;
            }
            int lvl = enchantments.getLevel(e);
            ResourceKey key = (ResourceKey)e.unwrapKey().get();
            if (LBDisassembledItem.equals(key, Enchantments.EFFICIENCY)) {
                batteryStack.enchant(e, lvl);
            } else if (e.is(EnchantmentTags.DAMAGE_EXCLUSIVE) || LBDisassembledItem.equals(key, Enchantments.KNOCKBACK)) {
                mediumStack.enchant(e, lvl);
            } else if (LBDisassembledItem.equals(key, Enchantments.FIRE_ASPECT) || LBDisassembledItem.equals(key, Enchantments.SWEEPING_EDGE) || LBDisassembledItem.equals(key, Enchantments.SILK_TOUCH)) {
                emitterStack.enchant(e, lvl);
            } else if (LBDisassembledItem.equals(key, Enchantments.VANISHING_CURSE)) {
                batteryStack.enchant(e, lvl);
                mediumStack.enchant(e, lvl);
                emitterStack.enchant(e, lvl);
                casingStack.enchant(e, lvl);
            } else {
                casingStack.enchant(e, lvl);
            }
        });
        LaserBladeAppearance appearance = LaserBladeAppearance.of(itemStack);
        LaserBladeAppearance mediumAppearance = LaserBladeAppearance.of();
        LaserBladeAppearance emitterAppearance = LaserBladeAppearance.of();
        LaserBladeAppearance casingAppearance = LaserBladeAppearance.of();
        mediumAppearance.setOuterColor(appearance.getOuterColor()).setOuterSubColor(appearance.isOuterSubColor()).setTo(mediumStack);
        emitterAppearance.setInnerColor(appearance.getInnerColor()).setInnerSubColor(appearance.isInnerSubColor()).setTo(emitterStack);
        casingAppearance.setGripColor(appearance.getGripColor()).setType(appearance.getType()).setTo(casingStack);
        if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            casingStack.set(DataComponents.CUSTOM_NAME, (Object)itemStack.getDisplayName());
        }
        player.addItem(batteryStack);
        player.addItem(mediumStack);
        player.addItem(emitterStack);
        player.addItem(casingStack);
    }

    private static boolean equals(ResourceKey<?> e1, ResourceKey<?> e2) {
        return e1.location().equals((Object)e2.location());
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipFlag flag, List<Component> tooltip) {
        ArrayList<Component> myTooltip = new ArrayList<Component>();
        LaserBladeItemUtil.addLaserBladeInformation(itemStack, tooltipContext, myTooltip, flag, this.upgradeType);
        tooltip.addAll(1, myTooltip);
    }
}

