/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.config.TLBServerConfig;
import com.github.iunius118.tolaserblade.core.dispenser.DispenseLaserBladeBehavior;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBlade;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeBlocking;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrade;
import com.github.iunius118.tolaserblade.mixin.ItemAccessor;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemUtil;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import com.github.iunius118.tolaserblade.world.item.ModToolMaterials;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;

public class LBSwordItem
extends Item
implements LaserBladeItemBase {
    public LBSwordItem(Item.Properties properties, boolean isFireResistant) {
        super(ModToolMaterials.getLBSwordMaterial(isFireResistant).applySwordProperties(properties, 3.0f, -1.2f));
        this.overwriteToolComponent(isFireResistant);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new DispenseLaserBladeBehavior());
    }

    private void overwriteToolComponent(boolean isFireResistant) {
        DataComponentMap.Builder builder = DataComponentMap.builder().addAll(this.components());
        float speed = ModToolMaterials.getLBSwordMaterial(isFireResistant).speed();
        builder.set(DataComponents.TOOL, (Object)new Tool(List.of(), speed, 1, false));
        builder.set(DataComponents.REPAIRABLE, null);
        builder.set(DataComponents.BLOCKS_ATTACKS, (Object)LaserBladeBlocking.getBlocksAttackComponent(isFireResistant));
        ((ItemAccessor)((Object)this)).setComponents(builder.build());
    }

    @Override
    public boolean canUpgrade(Upgrade.Type type) {
        return true;
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel serverLevel, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        if (!itemStack.has(DataComponents.ATTRIBUTE_MODIFIERS)) {
            LBSwordItem.updateItemAttributeModifiers(itemStack);
        }
    }

    public static void updateItemAttributeModifiers(ItemStack itemStack) {
        if (itemStack.getItem() instanceof LBSwordItem) {
            LaserBlade.updateItemAttributeModifiers(itemStack);
            LaserBladeAppearance.of(itemStack);
        }
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        Consumable consumable = (Consumable)stack.get(DataComponents.CONSUMABLE);
        if (consumable != null) {
            return consumable.animation();
        }
        return LaserBladeBlocking.getUseAnimation(stack);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Consumable consumable = (Consumable)itemstack.get(DataComponents.CONSUMABLE);
        if (consumable != null) {
            return consumable.startConsuming((LivingEntity)player, itemstack, hand);
        }
        Equippable equippable = (Equippable)itemstack.get(DataComponents.EQUIPPABLE);
        if (equippable != null && equippable.swappable()) {
            return equippable.swapWithEquipmentSlot(itemstack, player);
        }
        return LaserBladeBlocking.use(player, hand);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Level level = entity.level();
        if (!level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.swinging) {
                LaserBladeItemUtil.playSwingSound(level, entity, LaserBladeItemUtil.isFireResistant(stack));
            }
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public void hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        if (!level.isClientSide()) {
            LaserBladeItemUtil.playSwingSound(level, attacker, LaserBladeItemUtil.isFireResistant(stack));
            this.hurtAndBreak(stack, 1, attacker);
        }
    }

    public void onCriticalHit(CriticalHitEvent event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        ItemStack stack = player.getMainHandItem();
        if (target instanceof WitherBoss || LaserBlade.getAttack(stack) >= 8.0f) {
            event.setDamageMultiplier(event.getDamageMultiplier() + 0.5f);
        }
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!level.isClientSide() && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            this.hurtAndBreak(stack, 1, entityLiving);
        }
        return true;
    }

    private void hurtAndBreak(ItemStack stack, int damage, LivingEntity entityLiving) {
        stack.hurtAndBreak(damage, entityLiving, EquipmentSlot.MAINHAND);
        int count = stack.getCount();
        if (count > 0) {
            return;
        }
        stack.setCount(1);
        ItemStack brokenLaserBlade = LaserBladeItemUtil.isFireResistant(stack) ? stack.transmuteCopy((ItemLike)ModItems.LB_BROKEN_FP, 1) : stack.transmuteCopy((ItemLike)ModItems.LB_BROKEN, 1);
        brokenLaserBlade.remove(DataComponents.ATTRIBUTE_MODIFIERS);
        stack.setCount(count);
        Level level = entityLiving.level();
        ItemEntity itemEntity = new ItemEntity(level, entityLiving.getX(), entityLiving.getY() + 0.5, entityLiving.getZ(), brokenLaserBlade);
        level.addFreshEntity((Entity)itemEntity);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (!stack.has(DataComponents.TOOL)) {
            return TLBServerConfig.laserBladeEfficiency;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipFlag flag, List<Component> tooltip) {
        ArrayList<Component> myTooltip = new ArrayList<Component>();
        LaserBladeItemUtil.addLaserBladeInformation(itemStack, tooltipContext, myTooltip, flag, Upgrade.Type.OTHER);
        tooltip.addAll(1, myTooltip);
    }
}

