/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.core.laserblade.LaserBlade;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeColor;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import com.github.iunius118.tolaserblade.world.item.ModToolMaterials;
import com.github.iunius118.tolaserblade.world.item.enchantment.ModEnchantments;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public enum LaserBladeItemStack {
    ORIGINAL(p -> new ItemStack((ItemLike)ModItems.LASER_BLADE)),
    ICON(LaserBladeItemStack::getIconStack),
    MODEL_TYPE_526(p -> LaserBladeItemStack.getModelChangedStack(526, false, p)),
    LIGHT_ELEMENT_1(p -> LaserBladeItemStack.getLightElementStack(1, p)),
    LIGHT_ELEMENT_2(p -> LaserBladeItemStack.getLightElementStack(2, p)),
    GIFT(LaserBladeItemStack::getGiftStack),
    UPGRADED(p -> LaserBladeItemStack.getUpgradedStack(false, false, p)),
    DAMAGED(p -> LaserBladeItemStack.getUpgradedStack(false, true, p)),
    FULL_MOD(p -> LaserBladeItemStack.getFullModStack(false, false, p)),
    FP(p -> new ItemStack((ItemLike)ModItems.LASER_BLADE_FP)),
    UPGRADED_FP(p -> LaserBladeItemStack.getUpgradedStack(true, false, p)),
    DAMAGED_FP(p -> LaserBladeItemStack.getUpgradedStack(true, true, p)),
    FULL_MOD_FP(p -> LaserBladeItemStack.getFullModStack(false, true, p)),
    DISASSEMBLED_FULL_MOD(p -> LaserBladeItemStack.getFullModStack(true, false, p)),
    DISASSEMBLED_FULL_MOD_FP(p -> LaserBladeItemStack.getFullModStack(true, true, p));

    private final Function<HolderLookup.Provider, ItemStack> getter;

    private LaserBladeItemStack(Function<HolderLookup.Provider, ItemStack> getter) {
        this.getter = getter;
    }

    public ItemStack getCopy(HolderLookup.Provider lookupProvider) {
        return this.getter.apply(lookupProvider);
    }

    private static ItemStack getIconStack(HolderLookup.Provider lookupProvider) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.LASER_BLADE);
        new LaserBladeAppearance().setGripColor(LaserBladeColor.LIGHT_GRAY.getGripColor()).setTo(stack);
        return stack;
    }

    public static ItemStack getModelChangedStack(int type, boolean isFireproof, HolderLookup.Provider lookupProvider) {
        ItemStack stack = new ItemStack((ItemLike)(isFireproof ? ModItems.LASER_BLADE_FP : ModItems.LASER_BLADE));
        LaserBladeAppearance.of().setType(type).setTo(stack);
        return stack;
    }

    private static ItemStack getLightElementStack(int lightElementLevel, HolderLookup.Provider lookupProvider) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.LASER_BLADE);
        LaserBladeItemStack.enchant(stack, ModEnchantments.LIGHT_ELEMENT, lightElementLevel, lookupProvider);
        LaserBladeItemStack.enchant(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, 1, lookupProvider);
        return stack;
    }

    private static ItemStack getGiftStack(HolderLookup.Provider lookupProvider) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.LASER_BLADE);
        LaserBlade.setAttack(stack, 3.0f);
        LaserBlade.updateItemAttributeModifiers(stack);
        LaserBladeAppearance.of().setOuterColor(LaserBladeColor.LIME.getBladeColor()).setGripColor(LaserBladeColor.BROWN.getGripColor()).setTo(stack);
        LaserBladeItemStack.enchant(stack, ModEnchantments.LIGHT_ELEMENT, 5, lookupProvider);
        LaserBladeItemStack.enchant(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, 1, lookupProvider);
        return stack;
    }

    private static ItemStack getUpgradedStack(boolean isFireproof, boolean isDamaged, HolderLookup.Provider lookupProvider) {
        ItemStack stack = new ItemStack((ItemLike)(isFireproof ? ModItems.LASER_BLADE_FP : ModItems.LASER_BLADE));
        LaserBlade.setAttack(stack, 8.0f);
        LaserBlade.setSpeed(stack, 1.2f);
        LaserBlade.updateItemAttributeModifiers(stack);
        LaserBladeAppearance.of().setOuterColor(LaserBladeColor.BLUE.getBladeColor()).setInnerColor(LaserBladeColor.LIGHT_BLUE.getBladeColor()).setGripColor(LaserBladeColor.GRAY.getGripColor()).setTo(stack);
        LaserBladeItemStack.enchantMaxLevel(stack, ModEnchantments.LIGHT_ELEMENT, lookupProvider);
        LaserBladeItemStack.enchantMaxLevel(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, lookupProvider);
        LaserBladeItemStack.enchantMaxLevel(stack, (ResourceKey<Enchantment>)Enchantments.MENDING, lookupProvider);
        if (isDamaged) {
            ToolMaterial lbSwordMaterial = ModToolMaterials.getLBSwordMaterial(isFireproof);
            stack.setDamageValue(lbSwordMaterial.durability() - 1);
        }
        return stack;
    }

    private static ItemStack getFullModStack(boolean isDisassembled, boolean isFireproof, HolderLookup.Provider lookupProvider) {
        ItemStack stack = new ItemStack((ItemLike)(isDisassembled ? (isFireproof ? ModItems.LB_DISASSEMBLED_FP : ModItems.LB_DISASSEMBLED) : (isFireproof ? ModItems.LASER_BLADE_FP : ModItems.LASER_BLADE)));
        LaserBlade.setAttack(stack, 8.0f);
        LaserBlade.setSpeed(stack, 1.2f);
        LaserBlade.updateItemAttributeModifiers(stack);
        LaserBladeAppearance.of().setOuterColor(LaserBladeColor.CYAN.getBladeColor()).setOuterSubColor(true).setInnerColor(LaserBladeColor.WHITE.getBladeColor()).setInnerSubColor(true).setGripColor(LaserBladeColor.GRAY.getGripColor()).setTo(stack);
        LaserBladeItemStack.enchantMaxLevel(stack, ModEnchantments.LIGHT_ELEMENT, lookupProvider);
        LaserBladeItemStack.enchantMaxLevel(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, lookupProvider);
        LaserBladeItemStack.enchantMaxLevel(stack, (ResourceKey<Enchantment>)Enchantments.MENDING, lookupProvider);
        LaserBladeItemStack.enchantMaxLevel(stack, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT, lookupProvider);
        LaserBladeItemStack.enchantMaxLevel(stack, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE, lookupProvider);
        LaserBladeItemStack.enchantMaxLevel(stack, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, lookupProvider);
        LaserBladeItemStack.enchantMaxLevel(stack, (ResourceKey<Enchantment>)Enchantments.LOOTING, lookupProvider);
        return stack;
    }

    private static void enchant(ItemStack stack, ResourceKey<Enchantment> enchantmentKey, int level, HolderLookup.Provider lookupProvider) {
        Optional enchantment = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT).get(enchantmentKey);
        enchantment.ifPresent(e -> stack.enchant((Holder)e, level));
    }

    private static void enchantMaxLevel(ItemStack stack, ResourceKey<Enchantment> enchantmentKey, HolderLookup.Provider lookupProvider) {
        Optional enchantment = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT).get(enchantmentKey);
        enchantment.ifPresent(e -> stack.enchant((Holder)e, ((Enchantment)e.value()).getMaxLevel()));
    }
}

