/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.common.util.ModSoundEvents;
import com.github.iunius118.tolaserblade.config.TLBClientConfig;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBlade;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeTextKey;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrade;
import com.github.iunius118.tolaserblade.world.item.LBSwordItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class LaserBladeItemUtil {
    public static boolean isFireResistant(ItemStack itemStack) {
        DamageResistant damageResistant = (DamageResistant)itemStack.get(DataComponents.DAMAGE_RESISTANT);
        return damageResistant != null && damageResistant.types() == DamageTypeTags.IS_FIRE;
    }

    public static void changeDestroySpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemStack itemStack = player.getMainHandItem();
        Item item = itemStack.getItem();
        if (!(item instanceof LBSwordItem)) {
            return;
        }
        float destroySpeed = item.getDestroySpeed(itemStack, event.getState());
        float additionalSpeed = event.getOriginalSpeed() - destroySpeed;
        float efficiency = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.EFFICIENCY).map(e -> Float.valueOf(itemStack.getEnchantmentLevel((Holder)e))).orElse(Float.valueOf(1.0f)).floatValue();
        float rate = Mth.clamp((float)(efficiency / 5.0f), (float)0.0f, (float)1.0f);
        float newSpeed = rate * destroySpeed + additionalSpeed;
        event.setNewSpeed(newSpeed);
    }

    public static void playSwingSound(Level level, LivingEntity entity, boolean isFireResistant) {
        SoundEvent soundEvent = isFireResistant ? ModSoundEvents.ITEM_LASER_BLADE_FP_SWING : ModSoundEvents.ITEM_LASER_BLADE_SWING;
        Vec3 pos = entity.position();
        level.playSound(null, pos.x, pos.y, pos.z, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void playHitSound(Level level, Entity target, ItemStack itemStack) {
        SoundEvent soundEvent = LaserBladeItemUtil.isFireResistant(itemStack) ? ModSoundEvents.ITEM_LASER_BLADE_FP_HIT : ModSoundEvents.ITEM_LASER_BLADE_HIT;
        Vec3 pos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
        level.playSound(null, pos.x, pos.y, pos.z, soundEvent, target.getSoundSource(), 1.0f, 1.0f);
    }

    public static void playBlockSound(PlayLevelSoundEvent.AtPosition event) {
        if (TLBClientConfig.useShieldSoundForLaserBlade) {
            event.setSound((Holder)SoundEvents.SHIELD_BLOCK);
            event.setNewVolume(1.0f);
            event.setNewPitch(0.8f + event.getLevel().random.nextFloat() * 0.4f);
        } else {
            event.setNewVolume(1.0f);
            event.setNewPitch(1.0f);
        }
    }

    public static void addLaserBladeInformation(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag, Upgrade.Type upgradeType) {
        if (LaserBladeItemUtil.isFireResistant(itemStack)) {
            tooltip.add((Component)LaserBladeTextKey.KEY_TOOLTIP_FIREPROOF.translate().withStyle(ChatFormatting.GOLD));
        }
        switch (upgradeType) {
            case BATTERY: {
                LaserBladeItemUtil.addAttackSpeed(tooltip, LaserBlade.getSpeed(itemStack));
                break;
            }
            case MEDIUM: {
                LaserBladeItemUtil.addAttackDamage(tooltip, LaserBlade.getAttack(itemStack));
                break;
            }
            case EMITTER: {
                break;
            }
            case CASING: 
            case OTHER: {
                LaserBladeItemUtil.addModelType(tooltip, itemStack);
                break;
            }
            case REPAIR: {
                LaserBladeItemUtil.addModelType(tooltip, itemStack);
                LaserBladeItemUtil.addAttackDamage(tooltip, LaserBlade.getAttack(itemStack));
                LaserBladeItemUtil.addAttackSpeed(tooltip, LaserBlade.getSpeed(itemStack));
                break;
            }
        }
    }

    public static void addBrandNewText(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"tooltip.tolaserblade.brandNew1").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"tooltip.tolaserblade.brandNew2").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"tooltip.tolaserblade.brandNew3").withStyle(ChatFormatting.YELLOW));
    }

    private static void addModelType(List<Component> tooltip, ItemStack itemStack) {
        int modelType = LaserBladeAppearance.of(itemStack).getType();
        if (modelType >= 0) {
            tooltip.add((Component)LaserBladeTextKey.KEY_TOOLTIP_MODEL.translate(modelType).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    private static void addAttackDamage(List<Component> tooltip, float atk) {
        if (atk <= -0.005f || (double)atk >= 0.005) {
            tooltip.add(LaserBladeItemUtil.getUpgradeTextComponent(LaserBladeTextKey.KEY_TOOLTIP_ATTACK_DAMAGE.getKey(), atk));
        }
    }

    private static void addAttackSpeed(List<Component> tooltip, float spd) {
        if (spd <= -0.005f || (double)spd >= 0.005) {
            tooltip.add(LaserBladeItemUtil.getUpgradeTextComponent(LaserBladeTextKey.KEY_TOOLTIP_ATTACK_SPEED.getKey(), spd));
        }
    }

    private static Component getUpgradeTextComponent(String key, float value) {
        return Component.translatable((String)key, (Object[])new Object[]{(value < 0.0f ? "" : "+") + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value)}).withStyle(ChatFormatting.DARK_GREEN);
    }

    private LaserBladeItemUtil() {
    }
}

