/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.client.model.LaserBladeModelManager;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeTextKey;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemStack;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import com.github.iunius118.tolaserblade.world.item.enchantment.ModEnchantments;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class ModCreativeModeTabs {
    public static final CreativeModeTab TAB_LASER_BLADE = CreativeModeTab.builder().title((Component)LaserBladeTextKey.KEY_ITEM_GROUP_GENERAL.translate()).icon(() -> LaserBladeItemStack.ICON.getCopy(null)).displayItems((params, output) -> {
        HolderLookup.Provider lookupProvider = params.holders();
        output.accept((ItemLike)ModItems.DX_LASER_BLADE);
        output.accept((ItemLike)ModItems.LASER_BLADE);
        output.accept(LaserBladeItemStack.LIGHT_ELEMENT_1.getCopy(lookupProvider));
        Optional lightElement = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT).get(ModEnchantments.LIGHT_ELEMENT);
        lightElement.ifPresent(e -> output.accept(LaserBladeItemStack.LIGHT_ELEMENT_2.getCopy(lookupProvider)));
        output.accept(LaserBladeItemStack.GIFT.getCopy(lookupProvider));
        output.accept(LaserBladeItemStack.UPGRADED.getCopy(lookupProvider));
        output.accept(LaserBladeItemStack.DAMAGED.getCopy(lookupProvider));
        output.accept(LaserBladeItemStack.FULL_MOD.getCopy(lookupProvider));
        output.accept((ItemLike)ModItems.LASER_BLADE_FP);
        output.accept(LaserBladeItemStack.UPGRADED_FP.getCopy(lookupProvider));
        output.accept(LaserBladeItemStack.DAMAGED_FP.getCopy(lookupProvider));
        output.accept(LaserBladeItemStack.FULL_MOD_FP.getCopy(lookupProvider));
        output.accept((ItemLike)ModItems.LB_BRAND_NEW_1);
        output.accept((ItemLike)ModItems.LB_BRAND_NEW_2);
        output.accept((ItemLike)ModItems.LB_BRAND_NEW);
        output.accept((ItemLike)ModItems.LB_BRAND_NEW_FP);
        output.accept((ItemLike)ModItems.LB_BROKEN);
        output.accept((ItemLike)ModItems.LB_BROKEN_FP);
        output.accept((ItemLike)ModItems.LB_DISASSEMBLED);
        output.accept(LaserBladeItemStack.DISASSEMBLED_FULL_MOD.getCopy(lookupProvider));
        output.accept((ItemLike)ModItems.LB_DISASSEMBLED_FP);
        output.accept(LaserBladeItemStack.DISASSEMBLED_FULL_MOD_FP.getCopy(lookupProvider));
        output.accept((ItemLike)ModItems.LB_BLUEPRINT);
        output.accept((ItemLike)ModItems.LB_BATTERY);
        output.accept((ItemLike)ModItems.LB_MEDIUM);
        output.accept((ItemLike)ModItems.LB_EMITTER);
        output.accept((ItemLike)ModItems.LB_CASING);
        output.accept((ItemLike)ModItems.LB_CASING_FP);
    }).build();

    public static void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() != TAB_LASER_BLADE) {
            return;
        }
        List modelTypes = LaserBladeModelManager.getInstance().getModels().keySet().stream().sorted().toList();
        Iterator iterator = modelTypes.iterator();
        while (iterator.hasNext()) {
            int modelType = (Integer)iterator.next();
            if (modelType == 0) continue;
            ItemStack laserBlade = LaserBladeItemStack.getModelChangedStack(modelType, false, event.getParameters().holders());
            event.accept(laserBlade);
        }
    }
}

