/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrade;
import com.github.iunius118.tolaserblade.world.item.DXLaserBladeItem;
import com.github.iunius118.tolaserblade.world.item.LBBlueprintItem;
import com.github.iunius118.tolaserblade.world.item.LBBrandNewItem;
import com.github.iunius118.tolaserblade.world.item.LBBrandNewType;
import com.github.iunius118.tolaserblade.world.item.LBBrokenItem;
import com.github.iunius118.tolaserblade.world.item.LBDisassembledItem;
import com.github.iunius118.tolaserblade.world.item.LBPartItem;
import com.github.iunius118.tolaserblade.world.item.LBSwordItem;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItemRegistry {
    private static final DeferredRegister.Items itemRegister = DeferredRegister.createItems((String)"tolaserblade");
    public static final DeferredItem<Item> DX_LASER_BLADE = ModItemRegistry.registerItem("dx_laser_blade", DXLaserBladeItem::new);
    public static final DeferredItem<Item> LASER_BLADE = ModItemRegistry.registerLBSwordItem("laser_blade", false);
    public static final DeferredItem<Item> LASER_BLADE_FP = ModItemRegistry.registerLBSwordItem("laser_blade_fp", true);
    public static final DeferredItem<Item> LB_BRAND_NEW = ModItemRegistry.registerLBBrandNewItem("lb_brand_new", LBBrandNewType.NONE, false);
    public static final DeferredItem<Item> LB_BRAND_NEW_1 = ModItemRegistry.registerLBBrandNewItem("lb_brand_new_1", LBBrandNewType.LIGHT_ELEMENT_1, false);
    public static final DeferredItem<Item> LB_BRAND_NEW_2 = ModItemRegistry.registerLBBrandNewItem("lb_brand_new_2", LBBrandNewType.LIGHT_ELEMENT_2, false);
    public static final DeferredItem<Item> LB_BRAND_NEW_FP = ModItemRegistry.registerLBBrandNewItem("lb_brand_new_fp", LBBrandNewType.FP, true);
    public static final DeferredItem<Item> LB_BROKEN = ModItemRegistry.registerItem("lb_broken", LBBrokenItem::new);
    public static final DeferredItem<Item> LB_BROKEN_FP = ModItemRegistry.registerFireResistantItem("lb_broken_fp", LBBrokenItem::new);
    public static final DeferredItem<Item> LB_BLUEPRINT = ModItemRegistry.registerItem("lb_blueprint", LBBlueprintItem::new);
    public static final DeferredItem<Item> LB_DISASSEMBLED = ModItemRegistry.registerItem("lb_disassembled", LBDisassembledItem::new);
    public static final DeferredItem<Item> LB_DISASSEMBLED_FP = ModItemRegistry.registerFireResistantItem("lb_disassembled_fp", LBDisassembledItem::new);
    public static final DeferredItem<Item> LB_BATTERY = ModItemRegistry.registerLBPartItem("lb_battery", Upgrade.Type.BATTERY, false);
    public static final DeferredItem<Item> LB_MEDIUM = ModItemRegistry.registerLBPartItem("lb_medium", Upgrade.Type.MEDIUM, false);
    public static final DeferredItem<Item> LB_EMITTER = ModItemRegistry.registerLBPartItem("lb_emitter", Upgrade.Type.EMITTER, false);
    public static final DeferredItem<Item> LB_CASING = ModItemRegistry.registerLBPartItem("lb_casing", Upgrade.Type.CASING, false);
    public static final DeferredItem<Item> LB_CASING_FP = ModItemRegistry.registerLBPartItem("lb_casing_fp", Upgrade.Type.CASING, true);

    private static DeferredItem<Item> registerFireResistantItem(String name, Function<Item.Properties, Item> func) {
        return ModItemRegistry.registerItem(name, func, new Item.Properties().fireResistant());
    }

    private static DeferredItem<Item> registerLBSwordItem(String name, boolean isFireResistant) {
        return ModItemRegistry.registerItem(name, p -> new LBSwordItem((Item.Properties)p, isFireResistant), isFireResistant ? new Item.Properties().fireResistant() : new Item.Properties());
    }

    private static DeferredItem<Item> registerLBBrandNewItem(String name, LBBrandNewType type, boolean isFireResistant) {
        return ModItemRegistry.registerItem(name, p -> new LBBrandNewItem((Item.Properties)p, type), isFireResistant ? new Item.Properties().fireResistant() : new Item.Properties());
    }

    private static DeferredItem<Item> registerLBPartItem(String name, Upgrade.Type type, boolean isFireResistant) {
        return ModItemRegistry.registerItem(name, p -> new LBPartItem((Item.Properties)p, type), isFireResistant ? new Item.Properties().fireResistant() : new Item.Properties());
    }

    private static DeferredItem<Item> registerItem(String name, Function<Item.Properties, Item> func, Item.Properties properties) {
        return itemRegister.registerItem(name, func, properties);
    }

    private static DeferredItem<Item> registerItem(String name, Function<Item.Properties, Item> func) {
        return itemRegister.registerItem(name, func);
    }

    public static void register(IEventBus modEventBus) {
        ToLaserBlade.LOGGER.debug("Register mod items");
        itemRegister.register(modEventBus);
    }
}

