/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item.component;

import com.github.iunius118.tolaserblade.api.core.laserblade.LaserBladeState;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record LaserBladeModelData(int modelType, Map<String, PartData> parts) {
    public static final LaserBladeModelData DEFAULT = new LaserBladeModelData(0, Map.of());
    public static final Codec<LaserBladeModelData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("type", (Object)0).forGetter(LaserBladeModelData::modelType), (App)Codec.unboundedMap((Codec)Codec.STRING, PartData.CODEC).optionalFieldOf("parts", Map.of()).forGetter(LaserBladeModelData::parts)).apply((Applicative)instance, LaserBladeModelData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LaserBladeModelData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, LaserBladeModelData::modelType, (StreamCodec)ByteBufCodecs.map(Object2ObjectOpenHashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, PartData.STREAM_CODEC), LaserBladeModelData::parts, LaserBladeModelData::new);

    public LaserBladeModelData(int modelType, Map<String, PartData> parts) {
        this.modelType = modelType;
        this.parts = Objects.requireNonNullElse(parts, Map.of());
    }

    public record PartData(boolean exists, int color, boolean isSubtractiveColor) implements LaserBladeState.Part
    {
        public static final PartData ABSENT = new PartData(false, -1, false);
        public static final Codec<PartData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(PartData::color), (App)Codec.BOOL.fieldOf("is_sub").forGetter(PartData::isSubtractiveColor)).apply((Applicative)instance, PartData::create));
        public static final StreamCodec<RegistryFriendlyByteBuf, PartData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PartData::color, (StreamCodec)ByteBufCodecs.BOOL, PartData::isSubtractiveColor, PartData::create);

        public static PartData create(int color, boolean isSubtractiveColor) {
            return new PartData(true, color, isSubtractiveColor);
        }
    }
}

