/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item.crafting;

import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeColor;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeColorPart;
import com.github.iunius118.tolaserblade.world.item.crafting.LBSmithingRecipe;
import com.github.iunius118.tolaserblade.world.item.crafting.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public class LBColorRecipe
extends LBSmithingRecipe {
    final LaserBladeColorPart part;
    final int color;

    public LBColorRecipe(Optional<Ingredient> template, Ingredient base, Optional<Ingredient> addition, LaserBladeColorPart part, int color) {
        super(template, base, addition);
        this.part = part;
        this.color = color;
    }

    public boolean matches(SmithingRecipeInput smithingRecipeInput, Level level) {
        if (!super.matches(smithingRecipeInput, level)) {
            return false;
        }
        ItemStack baseStack = smithingRecipeInput.base();
        LaserBladeAppearance appearance = LaserBladeAppearance.of(baseStack);
        switch (this.part) {
            case INNER_BLADE: {
                return appearance.getInnerColor() != this.color || this.isSwitchingBlendModeColor();
            }
            case OUTER_BLADE: {
                return appearance.getOuterColor() != this.color || this.isSwitchingBlendModeColor();
            }
        }
        return appearance.getGripColor() != this.color;
    }

    private boolean isSwitchingBlendModeColor() {
        return LaserBladeColor.SPECIAL_SWITCH_BLEND_MODE.getOuterColor() == this.color;
    }

    public ItemStack assemble(SmithingRecipeInput smithingRecipeInput, HolderLookup.Provider provider) {
        ItemStack baseStack = smithingRecipeInput.base();
        ItemStack itemstack = baseStack.copy();
        return this.getColoringResult(itemstack);
    }

    private ItemStack getColoringResult(ItemStack input) {
        LaserBladeAppearance appearance = LaserBladeAppearance.of(input);
        switch (this.part) {
            case INNER_BLADE: {
                if (this.isSwitchingBlendModeColor()) {
                    appearance.switchInnerSubColor();
                    break;
                }
                appearance.setInnerColor(this.color);
                break;
            }
            case OUTER_BLADE: {
                if (this.isSwitchingBlendModeColor()) {
                    appearance.switchOuterSubColor();
                    break;
                }
                appearance.setOuterColor(this.color);
                break;
            }
            default: {
                appearance.setGripColor(this.color);
            }
        }
        appearance.setTo(input);
        return input;
    }

    @Override
    protected ItemStack getDisplayResult(ItemStack result) {
        return this.getColoringResult(result.copy());
    }

    public RecipeSerializer<LBColorRecipe> getSerializer() {
        return ModRecipeSerializers.COLOR;
    }

    public static class Serializer
    implements RecipeSerializer<LBColorRecipe> {
        private static final MapCodec<LBColorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.optionalFieldOf("template").forGetter(recipe -> recipe.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(recipe -> recipe.base), (App)Ingredient.CODEC.optionalFieldOf("addition").forGetter(recipe -> recipe.addition), (App)Codec.pair((Codec)Codec.STRING.fieldOf("part").codec(), (Codec)Codec.INT.fieldOf("color").codec()).fieldOf("result").forGetter(recipe -> new Pair((Object)recipe.part.getPartName(), (Object)recipe.color))).apply((Applicative)instance, (template, base, addition, result) -> new LBColorRecipe((Optional<Ingredient>)template, (Ingredient)base, (Optional<Ingredient>)addition, LaserBladeColorPart.byPartName((String)result.getFirst()), (Integer)result.getSecond())));
        private static final StreamCodec<RegistryFriendlyByteBuf, LBColorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<LBColorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LBColorRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static LBColorRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Optional template = (Optional)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient base = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Optional addition = (Optional)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.decode((Object)buffer);
            LaserBladeColorPart colorPart = LaserBladeColorPart.byIndex((Integer)ByteBufCodecs.INT.decode((Object)buffer));
            int color = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            return new LBColorRecipe(template, base, addition, colorPart, color);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, LBColorRecipe recipe) {
            Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.base);
            Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.addition);
            ByteBufCodecs.INT.encode((Object)buffer, (Object)recipe.part.getIndex());
            ByteBufCodecs.INT.encode((Object)buffer, (Object)recipe.color);
        }
    }
}

