/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item.crafting;

import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.world.item.crafting.LBSmithingRecipe;
import com.github.iunius118.tolaserblade.world.item.crafting.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public class LBModelChangeRecipe
extends LBSmithingRecipe {
    private final int type;

    public LBModelChangeRecipe(Optional<Ingredient> template, Ingredient base, Optional<Ingredient> addition, int type) {
        super(template, base, addition);
        this.type = type;
    }

    public boolean matches(SmithingRecipeInput smithingRecipeInput, Level level) {
        if (!super.matches(smithingRecipeInput, level)) {
            return false;
        }
        ItemStack baseStack = smithingRecipeInput.base();
        int baseType = LaserBladeAppearance.of(baseStack).getType();
        return this.type >= 0 && baseType != this.type;
    }

    public ItemStack assemble(SmithingRecipeInput smithingRecipeInput, HolderLookup.Provider provider) {
        ItemStack baseStack = smithingRecipeInput.base();
        ItemStack itemstack = baseStack.copy();
        return this.getResult(itemstack);
    }

    private ItemStack getResult(ItemStack input) {
        LaserBladeAppearance.of(input).setType(this.type).setTo(input);
        return input;
    }

    @Override
    protected ItemStack getDisplayResult(ItemStack result) {
        return this.getResult(result.copy());
    }

    public RecipeSerializer<LBModelChangeRecipe> getSerializer() {
        return ModRecipeSerializers.MODEL_CHANGE;
    }

    public static class Serializer
    implements RecipeSerializer<LBModelChangeRecipe> {
        private static final MapCodec<LBModelChangeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.optionalFieldOf("template").forGetter(recipe -> recipe.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(recipe -> recipe.base), (App)Ingredient.CODEC.optionalFieldOf("addition").forGetter(recipe -> recipe.addition), (App)Codec.INT.fieldOf("model_type").codec().fieldOf("result").forGetter(recipe -> recipe.type)).apply((Applicative)instance, LBModelChangeRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, LBModelChangeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<LBModelChangeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LBModelChangeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static LBModelChangeRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Optional template = (Optional)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient base = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Optional addition = (Optional)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int type = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            return new LBModelChangeRecipe(template, base, addition, type);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, LBModelChangeRecipe recipe) {
            Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.base);
            Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.addition);
            ByteBufCodecs.INT.encode((Object)buffer, (Object)recipe.type);
        }
    }
}

