/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item.crafting;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;

public abstract class LBSmithingRecipe
implements SmithingRecipe {
    protected final Optional<Ingredient> template;
    protected final Ingredient base;
    protected final Optional<Ingredient> addition;
    protected final ItemStack result;
    @Nullable
    private PlacementInfo placementInfo;

    public LBSmithingRecipe(Optional<Ingredient> template, Ingredient base, Optional<Ingredient> addition) {
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = LBSmithingRecipe.getResultItemStack(base);
    }

    private static ItemStack getResultItemStack(Ingredient base) {
        HolderSet items;
        Optional item;
        if (!base.isEmpty() && (item = (items = base.getValues()).stream().findFirst()).isPresent()) {
            return ((Item)((Holder)item.get()).value()).getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    public Optional<Ingredient> templateIngredient() {
        return this.template;
    }

    public Ingredient baseIngredient() {
        return this.base;
    }

    public Optional<Ingredient> additionIngredient() {
        return this.addition;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(List.of(this.template, Optional.of(this.base), this.addition));
        }
        return this.placementInfo;
    }

    public List<RecipeDisplay> display() {
        return List.of(new SmithingRecipeDisplay(Ingredient.optionalIngredientToDisplay(this.template), this.base.display(), Ingredient.optionalIngredientToDisplay(this.addition), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.getDisplayResult(this.result)), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.SMITHING_TABLE)));
    }

    protected abstract ItemStack getDisplayResult(ItemStack var1);
}

