/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.world.item.crafting;

import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeTextKey;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.Upgrade;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeID;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeManager;
import com.github.iunius118.tolaserblade.core.laserblade.upgrade.UpgradeResult;
import com.github.iunius118.tolaserblade.world.item.crafting.LBSmithingRecipe;
import com.github.iunius118.tolaserblade.world.item.crafting.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public class LBUpgradeRecipe
extends LBSmithingRecipe {
    private final ResourceLocation upgradeId;
    private Upgrade upgrade;

    public LBUpgradeRecipe(Optional<Ingredient> template, Ingredient base, Optional<Ingredient> addition, ResourceLocation upgradeId) {
        super(template, base, addition);
        this.upgradeId = upgradeId;
    }

    public boolean matches(SmithingRecipeInput smithingRecipeInput, Level level) {
        if (!super.matches(smithingRecipeInput, level)) {
            return false;
        }
        ItemStack baseStack = smithingRecipeInput.base();
        ItemStack additionalStack = smithingRecipeInput.addition();
        RegistryAccess provider = level.registryAccess();
        Upgrade upgrade = this.getUpgrade();
        return upgrade.canApply(baseStack, additionalStack, (HolderLookup.Provider)provider);
    }

    public ItemStack assemble(SmithingRecipeInput smithingRecipeInput, HolderLookup.Provider provider) {
        ItemStack baseStack = smithingRecipeInput.base();
        ItemStack itemstack = baseStack.copy();
        return this.getUpgradingResult(itemstack, provider);
    }

    private ItemStack getUpgradingResult(ItemStack input, HolderLookup.Provider provider) {
        Upgrade upgrade = this.getUpgrade();
        UpgradeResult result = upgrade.apply(input, 0, provider);
        return result.itemStack();
    }

    private Upgrade getUpgrade() {
        if (this.upgrade != null) {
            return this.upgrade;
        }
        this.upgrade = UpgradeManager.getUpgrade(this.upgradeId);
        return this.upgrade;
    }

    @Override
    protected ItemStack getDisplayResult(ItemStack result) {
        ResourceLocation efficiencyRemover = UpgradeID.EFFICIENCY_REMOVER.getID();
        ItemStack copied = result.copy();
        if (this.upgradeId.equals((Object)efficiencyRemover)) {
            MutableComponent componentContents = LaserBladeTextKey.KEY_TOOLTIP_REMOVE.translate(Component.translatable((String)"enchantment.minecraft.efficiency"));
            MutableComponent info = Component.literal((String)componentContents.getString());
            copied.set(DataComponents.CUSTOM_NAME, (Object)info);
            return copied;
        }
        return copied;
    }

    public RecipeSerializer<LBUpgradeRecipe> getSerializer() {
        return ModRecipeSerializers.UPGRADE;
    }

    public static class Serializer
    implements RecipeSerializer<LBUpgradeRecipe> {
        private static final MapCodec<LBUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.optionalFieldOf("template").forGetter(recipe -> recipe.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(recipe -> recipe.base), (App)Ingredient.CODEC.optionalFieldOf("addition").forGetter(recipe -> recipe.addition), (App)ResourceLocation.CODEC.fieldOf("type").codec().fieldOf("result").forGetter(recipe -> recipe.upgradeId)).apply((Applicative)instance, LBUpgradeRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, LBUpgradeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<LBUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LBUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static LBUpgradeRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Optional template = (Optional)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient base = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Optional addition = (Optional)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ResourceLocation upgradeId = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            return new LBUpgradeRecipe(template, base, addition, upgradeId);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, LBUpgradeRecipe recipe) {
            Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.base);
            Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.addition);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.upgradeId);
        }
    }
}

