/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem.api;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.golem.StrawGolem;
import org.hero.strawgolem.golem.api.BiPredicate;

public class VisionHelper {
    public static boolean canSee(Entity pos1, BlockPos pos2) {
        if (pos1 == null || pos2 == null) {
            Object error = "";
            if (pos1 == null) {
                error = (String)error + "Entity";
            }
            if (pos2 == null) {
                error = (String)error + "BlockPos";
            }
            Constants.LOG.error("VisonHelper error! " + (String)error);
            return false;
        }
        if (Math.abs(pos1.getY() - (double)pos2.getY()) > 3.0) {
            return false;
        }
        return Math.sqrt(Math.pow(pos1.getX() - (double)pos2.getX(), 2.0) + Math.pow(pos1.getZ() - (double)pos2.getZ(), 2.0)) <= (double)Constants.Golem.searchRange;
    }

    public static BlockPos findNearestBlock(StrawGolem golem, BiPredicate test) {
        int range = Constants.Golem.searchRange;
        BlockPos closest = null;
        BlockPos query = golem.blockPosition();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range / 2; y <= range / 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos = query.offset(x, y, z);
                    if (!test.filter(golem, pos)) continue;
                    closest = closest == null || query.distManhattan((Vec3i)pos) < query.distManhattan((Vec3i)closest) ? pos : closest;
                }
            }
        }
        return closest;
    }

    public static Queue<BlockPos> nearbyBlocks(StrawGolem golem, BiPredicate test) {
        int range = Constants.Golem.searchRange;
        PriorityQueue<BlockPos> queue = new PriorityQueue<BlockPos>(Comparator.comparingInt(pos -> pos.distManhattan((Vec3i)golem.blockPosition())));
        BlockPos closest = null;
        BlockPos query = golem.blockPosition();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range / 2; y <= range / 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos2 = query.offset(x, y, z);
                    if (!test.filter(golem, pos2)) continue;
                    closest = closest == null || query.distManhattan((Vec3i)pos2) < query.distManhattan((Vec3i)closest) ? pos2 : closest;
                    queue.add(pos2);
                }
            }
        }
        return queue;
    }
}

