/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.config;

import java.util.HashMap;
import java.util.Map;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.config.SimpleConfig;

public class Config {
    private SimpleConfig CONFIG;
    private String file = "";
    private Map<String, Object> defaults = new HashMap<String, Object>();

    public Config() {
        this.section("Strawgolem Config");
        this.file = this.file + "\n";
        this.section("Golem Health");
        this.add("Max Health", Float.valueOf(6.0f), "The max health of a golem.");
        this.add("Barrel Max Health", 100, "The max health of a barrel.");
        this.section("Golem Movement");
        this.add("Walk Speed", 0.5, "The walk speed of a golem.");
        this.add("Run Speed", 0.8, "The run speed of a golem.");
        this.add("Wander Range", 24, "How far a golem can wander");
        this.add("Panic When Hurt", true, "Whether a golem should panic when hurt.");
        this.section("Golem Harvesting");
        this.add("Harvest Range", 24, "Range for a golem to detect crops and chests.");
        this.add("Block Harvesting", true, "Whether a golem should harvest crop blocks like pumpkins and melons.");
        this.add("Use Whitelist", false, "Whether a golem should only harvest crops in the whitelist.");
        this.add("Crop Whitelist", " ", "What crops should be harvested, please use valid resource locations.");
        this.CONFIG = SimpleConfig.of("strawgolem").provider(this::provider).request();
        System.out.println(this.CONFIG.isBroken());
    }

    private String provider() {
        return this.file;
    }

    private void add(String key, Object value) {
        this.file = this.file + key + "=" + String.valueOf(value) + "\n";
        this.defaults.put(key, value);
    }

    private void add(String key, Object value, String description) {
        this.description(description);
        this.add(key, value);
    }

    private void section(String section) {
        this.file = this.file + "# [" + section + "]\n";
    }

    private void description(String comment) {
        this.file = this.file + "# " + comment + "\n";
    }

    int getOrDefault(String key, Integer defaultValue) {
        return this.CONFIG.getOrDefault(key, defaultValue);
    }

    boolean getOrDefault(String key, Boolean defaultValue) {
        return this.CONFIG.getOrDefault(key, defaultValue);
    }

    String getOrDefault(String key, String defaultValue) {
        return this.CONFIG.getOrDefault(key, defaultValue);
    }

    double getOrDefault(String key, Double defaultValue) {
        return this.CONFIG.getOrDefault(key, defaultValue);
    }

    public Object getObject(String key) {
        Object defaultVal = this.defaults.get(key);
        if (this.CONFIG.get(key) == null) {
            return defaultVal;
        }
        return this.CONFIG.get(key);
    }

    public double getDouble(String key) {
        try {
            return Double.parseDouble((String)this.getObject(key));
        }
        catch (Throwable e) {
            Constants.LOG.error(e.getMessage());
            try {
                return Double.parseDouble((String)this.defaults.get(key));
            }
            catch (Throwable q) {
                Constants.LOG.error(q.getMessage());
                return 1.0;
            }
        }
    }

    public float getFloat(String key) {
        try {
            return Float.parseFloat((String)this.getObject(key));
        }
        catch (Throwable e) {
            Constants.LOG.error(e.getMessage());
            try {
                return Float.parseFloat((String)this.defaults.get(key));
            }
            catch (Throwable q) {
                Constants.LOG.error(q.getMessage());
                return 1.0f;
            }
        }
    }

    public int getInt(String key) {
        try {
            return Integer.parseInt((String)this.getObject(key));
        }
        catch (Throwable e) {
            Constants.LOG.error(e.getMessage());
            try {
                return Integer.parseInt((String)this.defaults.get(key));
            }
            catch (Throwable q) {
                Constants.LOG.error(q.getMessage());
                return 1;
            }
        }
    }

    public boolean getBool(String key) {
        try {
            return Boolean.parseBoolean((String)this.getObject(key));
        }
        catch (Throwable e) {
            Constants.LOG.error(e.getMessage());
            try {
                return Boolean.parseBoolean((String)this.defaults.get(key));
            }
            catch (Throwable q) {
                Constants.LOG.error(q.getMessage());
                return false;
            }
        }
    }

    public String getString(String key) {
        try {
            return (String)this.getObject(key);
        }
        catch (Throwable e) {
            Constants.LOG.error(e.getMessage());
            try {
                return (String)this.defaults.get(key);
            }
            catch (Throwable q) {
                Constants.LOG.error(q.getMessage());
                return "";
            }
        }
    }
}

