/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem;

import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.client.GolemArmAnimationController;
import org.hero.strawgolem.client.GolemHarvestAnimationController;
import org.hero.strawgolem.client.GolemLegAnimationController;
import org.hero.strawgolem.golem.api.BiPredicate;
import org.hero.strawgolem.golem.api.ContainerHelper;
import org.hero.strawgolem.golem.api.ReachHelper;
import org.hero.strawgolem.golem.api.VisionHelper;
import org.hero.strawgolem.golem.goals.GolemDepositGoal;
import org.hero.strawgolem.golem.goals.GolemHarvestGoal;
import org.hero.strawgolem.golem.goals.GolemWanderGoal;
import org.hero.strawgolem.mixinInterfaces.GolemOrderer;
import org.hero.strawgolem.registry.ItemRegistry;
import org.hero.strawgolem.registry.SoundRegistry;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class StrawGolem
extends AbstractGolem
implements GeoAnimatable {
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final Deliverer deliverer = new Deliverer();
    public final Harvester harvester = new Harvester(this);
    public static final double defaultMovement = 0.23;
    public static final double defaultWalkSpeed = Constants.Golem.defaultWalkSpeed;
    public static final float baseHealth = Constants.Golem.maxHealth;
    private static final EntityDataAccessor<Boolean> HAT = SynchedEntityData.defineId(StrawGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> CARRY_STATUS = SynchedEntityData.defineId(StrawGolem.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PICKUP_STATUS = SynchedEntityData.defineId(StrawGolem.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BARREL = SynchedEntityData.defineId(StrawGolem.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockPos> PRIORITY_POS = SynchedEntityData.defineId(StrawGolem.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private boolean forceAnimationReset = false;

    public StrawGolem(EntityType<? extends StrawGolem> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new GolemWanderGoal(this));
        this.goalSelector.addGoal(1, (Goal)new GolemDepositGoal(this));
        this.goalSelector.addGoal(1, (Goal)new GolemHarvestGoal(this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(CARRY_STATUS, (Object)0);
        pBuilder.define(PICKUP_STATUS, (Object)0);
        pBuilder.define(HAT, (Object)false);
        pBuilder.define(BARREL, (Object)0);
        pBuilder.define(PRIORITY_POS, (Object)new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add((AnimationController)new GolemArmAnimationController(this));
        registrar.add((AnimationController)new GolemLegAnimationController(this));
        registrar.add((AnimationController)new GolemHarvestAnimationController(this));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.MAX_HEALTH, (double)baseHealth);
    }

    public void tick() {
        Item item = this.getMainHandItem().getItem();
        if (item instanceof BlockItem) {
            this.setCarryStatus(2);
        } else if (!this.getMainHandItem().isEmpty()) {
            this.setCarryStatus(1);
        } else {
            this.setCarryStatus(0);
        }
        super.tick();
    }

    protected InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        if (this.level().isClientSide) {
            return InteractionResult.PASS;
        }
        pPlayer.playSound(SoundRegistry.GOLEM_HAPPY.get());
        ItemStack item = pPlayer.getMainHandItem();
        if (pHand == InteractionHand.MAIN_HAND && item != ItemStack.EMPTY) {
            if (item.is(Items.BARREL) && this.barrelHP() != Constants.Golem.barrelHealth) {
                this.entityData.set(BARREL, (Object)Constants.Golem.barrelHealth);
                item.shrink(1);
            } else if (item.is(Items.WHEAT) && this.healthStatus() != 0) {
                if (this.getMaxHealth() - this.getHealth() < 3.0f) {
                    this.setHealth(this.getMaxHealth());
                } else {
                    this.setHealth(this.getHealth() + 3.0f);
                }
                item.shrink(1);
            } else if (item.is(ItemRegistry.STRAW_HAT.get()) && !this.hasHat()) {
                this.entityData.set(HAT, (Object)true);
            }
            return InteractionResult.CONSUME;
        }
        if (pHand == InteractionHand.MAIN_HAND && pPlayer.getMainHandItem().isEmpty() && pPlayer.isCrouching() && pPlayer instanceof GolemOrderer) {
            GolemOrderer orderer = (GolemOrderer)pPlayer;
            if (orderer.strawgolemRewrite$getGolem() == null || !orderer.strawgolemRewrite$getGolem().equals((Object)this)) {
                orderer.strawgolemRewrite$setGolem(this);
                pPlayer.displayClientMessage((Component)Component.translatable((String)"strawgolem.ordering.start"), true);
            } else {
                orderer.strawgolemRewrite$setGolem(null);
                pPlayer.displayClientMessage((Component)Component.translatable((String)"strawgolem.ordering.stop"), true);
            }
        }
        return super.mobInteract(pPlayer, pHand);
    }

    protected void actuallyHurt(DamageSource pDamageSource, float pDamageAmount) {
        if ((float)this.barrelHP() - pDamageAmount >= 0.0f) {
            this.entityData.set(BARREL, (Object)((int)((float)this.barrelHP() - pDamageAmount)));
            this.playSound(SoundEvents.SHIELD_BLOCK);
            return;
        }
        if (this.hasBarrel()) {
            pDamageAmount -= (float)this.barrelHP();
            this.entityData.set(BARREL, (Object)0);
            this.playSound(SoundEvents.SHIELD_BREAK);
        }
        super.actuallyHurt(pDamageSource, pDamageAmount);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(HAT, (Object)tag.getBoolean("hat"));
        this.entityData.set(CARRY_STATUS, (Object)tag.getInt("carry"));
        this.entityData.set(BARREL, (Object)tag.getInt("barrelHP"));
        this.entityData.set(PRIORITY_POS, (Object)BlockPos.of((long)tag.getLong("priorityPos")));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean("hat", this.hasHat());
        tag.putInt("carry", this.carryStatus());
        tag.putInt("barrelHP", this.barrelHP());
        tag.putLong("priorityPos", ((BlockPos)this.entityData.get(PRIORITY_POS)).asLong());
        super.addAdditionalSaveData(tag);
    }

    public int healthStatus() {
        return this.getMaxHealth() - 1.0E-4f <= this.getHealth() ? 0 : ((double)this.getMaxHealth() * 0.333333 < (double)this.getHealth() ? 1 : 2);
    }

    public int movementStatus() {
        double movement = this.getDeltaMovement().horizontalDistance() * (double)this.level().tickRateManager().tickrate();
        return movement == 0.0 ? 0 : (movement < defaultWalkSpeed * 0.8 ? 1 : 2);
    }

    public int carryStatus() {
        return (Integer)this.entityData.get(CARRY_STATUS);
    }

    public void setCarryStatus(int status) {
        this.entityData.set(CARRY_STATUS, (Object)status);
    }

    public int pickupStatus() {
        return (Integer)this.entityData.get(PICKUP_STATUS);
    }

    public void setPickupStatus(int status) {
        this.entityData.set(PICKUP_STATUS, (Object)status);
    }

    public void setPickupStatus(ItemStack item) {
        if (!item.isEmpty()) {
            if (item.getItem() instanceof BlockItem) {
                this.setPickupStatus(2);
            } else {
                this.setPickupStatus(1);
            }
        } else {
            this.setPickupStatus(0);
        }
    }

    public boolean isScared() {
        return false;
    }

    public boolean holdItemAbove() {
        return this.carryStatus() == 2 || this.hasBarrel();
    }

    public boolean hasHat() {
        return (Boolean)this.entityData.get(HAT);
    }

    public int barrelHP() {
        return (Integer)this.entityData.get(BARREL);
    }

    public boolean hasBarrel() {
        return this.barrelHP() != 0;
    }

    public void setPriorityPos(BlockPos pos) {
        this.entityData.set(PRIORITY_POS, (Object)pos);
    }

    public BlockPos getPriorityPos() {
        return (BlockPos)this.entityData.get(PRIORITY_POS);
    }

    public boolean shouldForceAnimationReset() {
        if (this.forceAnimationReset) {
            this.forceAnimationReset = false;
            return true;
        }
        return false;
    }

    public void forceAnimationReset() {
        this.forceAnimationReset = true;
    }

    public class Deliverer {
        BlockPos storagePos;

        public BlockPos getDeliverable() {
            StrawGolem golem = StrawGolem.this;
            BiPredicate predicate = (gol, pos) -> VisionHelper.canSee((Entity)gol, pos) && ContainerHelper.isContainer((Mob)gol, pos) && ReachHelper.canPath((Mob)gol, pos);
            if (StrawGolem.this.getPriorityPos().getX() != Integer.MAX_VALUE && predicate.filter(golem, StrawGolem.this.getPriorityPos())) {
                return StrawGolem.this.getPriorityPos();
            }
            if (this.storagePos != null && predicate.filter(golem, this.storagePos)) {
                return this.storagePos;
            }
            BlockPos pos2 = VisionHelper.findNearestBlock(golem, predicate);
            this.storagePos = this.storagePos == null || !predicate.filter(golem, this.storagePos) ? pos2 : this.storagePos;
            return pos2;
        }

        public void deliver(LevelReader level, BlockPos pos) {
            ItemStack item = StrawGolem.this.getMainHandItem();
            if (!item.isEmpty() && ContainerHelper.isContainer(level, pos)) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof Container) {
                    ItemStack cItem;
                    int i;
                    Container container = (Container)blockEntity;
                    for (i = 0; i < container.getContainerSize(); ++i) {
                        cItem = container.getItem(i);
                        if (!cItem.is(item.getItem()) || container.getMaxStackSize(cItem) <= cItem.getCount()) continue;
                        cItem.grow(item.getCount());
                        container.setItem(i, cItem);
                        StrawGolem.this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                        return;
                    }
                    for (i = 0; i < container.getContainerSize(); ++i) {
                        cItem = container.getItem(i);
                        if (!cItem.isEmpty() || container.getMaxStackSize() <= cItem.getCount()) continue;
                        container.setItem(i, item);
                        StrawGolem.this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                        return;
                    }
                }
            } else {
                Constants.LOG.error("Delivery location is not a container! {} {}", (Object)item.isEmpty(), (Object)ContainerHelper.isContainer(level, pos));
            }
        }
    }

    public class Harvester {
        Queue<BlockPos> harvestLocations;

        public Harvester(StrawGolem this$0) {
        }

        BlockPos nextLocation() {
            return this.harvestLocations == null ? null : this.harvestLocations.poll();
        }
    }
}

