/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.LevelReader;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.golem.StrawGolem;
import org.hero.strawgolem.golem.api.ContainerHelper;
import org.hero.strawgolem.golem.api.ReachHelper;
import org.hero.strawgolem.golem.api.VisionHelper;
import org.hero.strawgolem.golem.goals.GolemMoveToBlockGoal;

public class GolemDepositGoal
extends GolemMoveToBlockGoal {
    private StrawGolem golem;
    private boolean done = false;

    public GolemDepositGoal(StrawGolem golem) {
        super((PathfinderMob)golem, Constants.Golem.defaultWalkSpeed, Constants.Golem.searchRange, 3);
        this.golem = golem;
    }

    public void start() {
        this.blockPos = this.golem.deliverer.getDeliverable();
        if (this.blockPos == null) {
            Constants.LOG.error("Deposit Start Error!");
            this.stop();
            this.done = true;
        } else {
            this.moveMobToBlock();
            this.tryTicks = 0;
        }
    }

    public void tick() {
        super.tick();
        if (this.blockPos == null) {
            Constants.LOG.error("Missing block position!");
        } else if (this.mob.hasItemInSlot(EquipmentSlot.MAINHAND) && ReachHelper.canReach((Mob)this.mob, this.blockPos)) {
            this.golem.deliverer.deliver((LevelReader)this.golem.level(), this.blockPos);
            this.golem.getNavigation().stop();
            this.done = true;
        } else if (this.shouldRecalculatePath() && this.golemCollision(this.golem)) {
            this.nudge(this.golem);
        }
    }

    public boolean canUse() {
        return this.mob.hasItemInSlot(EquipmentSlot.MAINHAND) && this.golem.deliverer.getDeliverable() != null;
    }

    public boolean canContinueToUse() {
        return !this.done && ContainerHelper.isContainer((Mob)this.mob, this.blockPos) && this.canUse() && this.golem.getNavigation().getPath() != null;
    }

    protected void moveMobToBlock() {
        try {
            this.mob.getNavigation().moveTo((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5, 0, this.speedModifier);
        }
        catch (Exception e) {
            this.stop();
            Constants.LOG.error(e.getMessage());
        }
    }

    @Override
    protected boolean isValidTarget(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBlockEntity(blockPos) instanceof Container && VisionHelper.canSee((Entity)this.mob, this.mob.getOnPos());
    }
}

