/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem.goals;

import java.util.Collections;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.golem.StrawGolem;
import org.hero.strawgolem.golem.api.BiPredicate;
import org.hero.strawgolem.golem.api.ReachHelper;
import org.hero.strawgolem.golem.api.VisionHelper;
import org.hero.strawgolem.golem.goals.GolemMoveToBlockGoal;

public class GolemHarvestGoal
extends GolemMoveToBlockGoal {
    private StrawGolem golem;
    private Queue<BlockPos> queue;
    private int harvestTimer = 0;
    private ItemStack item;
    private BiPredicate predicate = (gol, pos) -> this.isGrownPlant((LevelReader)gol.level(), pos) && ReachHelper.canPath((Mob)gol, pos);

    public GolemHarvestGoal(StrawGolem golem) {
        super((PathfinderMob)golem, Constants.Golem.defaultWalkSpeed, Constants.Golem.searchRange, 3);
        this.golem = golem;
    }

    @Override
    protected boolean isValidTarget(LevelReader levelReader, BlockPos blockPos) {
        return VisionHelper.canSee((Entity)this.golem, blockPos) && this.predicate.filter(this.golem, blockPos);
    }

    public void tick() {
        try {
            super.tick();
            if (ReachHelper.canReach((Mob)this.mob, this.blockPos) && this.item == null) {
                this.item = this.harvest();
                this.golem.setPickupStatus(this.item);
                this.golem.getNavigation().stop();
            } else if (this.item != null && !this.item.isEmpty()) {
                ++this.harvestTimer;
                if (this.harvestTimer == 20 && this.predicate.filter(this.golem, this.blockPos) && ReachHelper.canReach((Mob)this.mob, this.blockPos)) {
                    this.item = this.harvest();
                    this.blockReset(this.golem.level());
                    this.golem.setItemSlot(EquipmentSlot.MAINHAND, this.item);
                } else if (this.harvestTimer == 40) {
                    this.golem.setPickupStatus(0);
                } else if (this.harvestTimer < 20 && !this.predicate.filter(this.golem, this.blockPos)) {
                    this.golem.forceAnimationReset();
                    this.golem.setPickupStatus(0);
                    this.item = null;
                }
            } else if (this.shouldRecalculatePath() && this.golemCollision(this.golem)) {
                this.nudge(this.golem);
            }
        }
        catch (Exception e) {
            Constants.LOG.error(e.getMessage());
            this.stop();
        }
    }

    public void start() {
        if (this.blockPos == null) {
            this.blockPos = this.queue.poll();
        }
        this.moveMobToBlock();
        this.tryTicks = 0;
        this.harvestTimer = 0;
        this.item = null;
    }

    public void stop() {
        this.golem.setPickupStatus(0);
    }

    protected void moveMobToBlock() {
        this.mob.getNavigation().moveTo((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5, 0, this.speedModifier);
    }

    public boolean canUse() {
        if (this.golem.getMainHandItem().isEmpty() && this.queue == null) {
            this.queue = VisionHelper.nearbyBlocks(this.golem, this.predicate);
        } else if (this.queue != null && this.queue.isEmpty()) {
            this.queue = VisionHelper.nearbyBlocks(this.golem, this.predicate);
        }
        if (this.queue == null || this.queue.isEmpty()) {
            return false;
        }
        do {
            this.blockPos = this.queue.poll();
        } while (!this.predicate.filter(this.golem, this.blockPos) && !this.queue.isEmpty());
        return this.golem.getMainHandItem().isEmpty() && this.isValidTarget((LevelReader)this.golem.level(), this.blockPos);
    }

    public boolean canContinueToUse() {
        return this.harvestTimer <= 38 && (this.golem.getMainHandItem().isEmpty() || this.harvestTimer <= 40) && this.isValidTarget((LevelReader)this.golem.level(), this.blockPos);
    }

    private boolean isPlant(LevelReader levelReader, BlockPos blockPos) {
        return levelReader != null && blockPos != null && levelReader.getBlockState(blockPos).getBlock() instanceof CropBlock;
    }

    private boolean isGrownPlant(LevelReader levelReader, BlockPos blockPos) {
        if (levelReader == null || blockPos == null) {
            return false;
        }
        BlockState state = levelReader.getBlockState(blockPos);
        Object object = state.getBlock();
        if (object instanceof CropBlock) {
            CropBlock crop = (CropBlock)object;
            return crop.isMaxAge(state);
        }
        object = state.getBlock();
        if (object instanceof BushBlock) {
            BushBlock bush = (BushBlock)object;
            for (Property prop : state.getProperties()) {
                if (!(prop instanceof IntegerProperty)) continue;
                IntegerProperty intProp = (IntegerProperty)prop;
                if (!prop.getName().equals("age") || (Integer)state.getValue((Property)intProp) < (Integer)Collections.max(intProp.getPossibleValues())) continue;
                return true;
            }
        } else if (Constants.Golem.blockHarvest && state.getBlock() == Blocks.PUMPKIN || state.getBlock() == Blocks.MELON) {
            try {
                for (Direction dir : Direction.values()) {
                    if (!(levelReader.getBlockState(blockPos.relative(dir)).getBlock() instanceof AttachedStemBlock) || !state.hasProperty((Property)AttachedStemBlock.FACING) || !blockPos.relative(dir).relative((Direction)state.getValue((Property)AttachedStemBlock.FACING)).equals((Object)blockPos)) continue;
                    return true;
                }
            }
            catch (Throwable e) {
                Constants.LOG.error(e.getMessage());
                return false;
            }
        }
        return false;
    }

    public ItemStack harvest() {
        Level level = this.golem.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockState state = level2.getBlockState(this.blockPos);
            LootParams.Builder builder = new LootParams.Builder(level2).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.ORIGIN, (Object)this.mob.position());
            ItemStack drops = state.getDrops(builder).stream().filter(this::isCropDrop).findFirst().orElse(ItemStack.EMPTY);
            return drops;
        }
        Constants.LOG.error("Golem level not ServerLevel!");
        return ItemStack.EMPTY;
    }

    private void blockReset(Level level) {
        BlockState state = level.getBlockState(this.blockPos);
        for (Property prop : state.getProperties()) {
            if (!prop.getName().equalsIgnoreCase("age") || !(prop instanceof IntegerProperty)) continue;
            IntegerProperty intprop = (IntegerProperty)prop;
            int value = (Integer)state.getBlock().defaultBlockState().getValue((Property)intprop);
            level.playSound(null, this.blockPos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS);
            state = (BlockState)state.setValue((Property)intprop, (Comparable)Integer.valueOf(value));
            level.setBlockAndUpdate(this.blockPos, state);
        }
    }

    private boolean isCropDrop(ItemStack item) {
        return !(item.getItem() instanceof ItemNameBlockItem) || item.getItem().components().has(DataComponents.FOOD);
    }
}

