/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem;

import java.util.Queue;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1427;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.client.GolemArmAnimationController;
import org.hero.strawgolem.client.GolemHarvestAnimationController;
import org.hero.strawgolem.client.GolemLegAnimationController;
import org.hero.strawgolem.golem.api.BiPredicate;
import org.hero.strawgolem.golem.api.ContainerHelper;
import org.hero.strawgolem.golem.api.ReachHelper;
import org.hero.strawgolem.golem.api.VisionHelper;
import org.hero.strawgolem.golem.goals.GolemDepositGoal;
import org.hero.strawgolem.golem.goals.GolemHarvestGoal;
import org.hero.strawgolem.golem.goals.GolemWanderGoal;
import org.hero.strawgolem.mixinInterfaces.GolemOrderer;
import org.hero.strawgolem.registry.ItemRegistry;
import org.hero.strawgolem.registry.SoundRegistry;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class StrawGolem
extends class_1427
implements GeoAnimatable {
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final Deliverer deliverer = new Deliverer();
    public final Harvester harvester = new Harvester(this);
    public static final double defaultMovement = 0.23;
    public static final double defaultWalkSpeed = Constants.Golem.defaultWalkSpeed;
    public static final float baseHealth = Constants.Golem.maxHealth;
    private static final class_2940<Boolean> HAT = class_2945.method_12791(StrawGolem.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> CARRY_STATUS = class_2945.method_12791(StrawGolem.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> PICKUP_STATUS = class_2945.method_12791(StrawGolem.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BARREL = class_2945.method_12791(StrawGolem.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2338> PRIORITY_POS = class_2945.method_12791(StrawGolem.class, (class_2941)class_2943.field_13324);
    private boolean forceAnimationReset = false;

    public StrawGolem(class_1299<? extends StrawGolem> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new GolemWanderGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GolemDepositGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GolemHarvestGoal(this));
    }

    protected void method_5693(class_2945.class_9222 pBuilder) {
        super.method_5693(pBuilder);
        pBuilder.method_56912(CARRY_STATUS, (Object)0);
        pBuilder.method_56912(PICKUP_STATUS, (Object)0);
        pBuilder.method_56912(HAT, (Object)false);
        pBuilder.method_56912(BARREL, (Object)0);
        pBuilder.method_56912(PRIORITY_POS, (Object)new class_2338(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add((AnimationController)new GolemArmAnimationController(this));
        registrar.add((AnimationController)new GolemLegAnimationController(this));
        registrar.add((AnimationController)new GolemHarvestAnimationController(this));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23716, (double)baseHealth);
    }

    public void method_5773() {
        class_1792 item = this.method_6047().method_7909();
        if (item instanceof class_1747) {
            this.setCarryStatus(2);
        } else if (!this.method_6047().method_7960()) {
            this.setCarryStatus(1);
        } else {
            this.setCarryStatus(0);
        }
        super.method_5773();
    }

    protected class_1269 method_5992(class_1657 pPlayer, class_1268 pHand) {
        if (this.method_37908().field_9236) {
            return class_1269.field_5811;
        }
        pPlayer.method_43077(SoundRegistry.GOLEM_HAPPY.get());
        class_1799 item = pPlayer.method_6047();
        if (pHand == class_1268.field_5808 && item != class_1799.field_8037) {
            if (item.method_31574(class_1802.field_16307) && this.barrelHP() != Constants.Golem.barrelHealth) {
                this.field_6011.method_12778(BARREL, (Object)Constants.Golem.barrelHealth);
                item.method_7934(1);
            } else if (item.method_31574(class_1802.field_8861) && this.healthStatus() != 0) {
                if (this.method_6063() - this.method_6032() < 3.0f) {
                    this.method_6033(this.method_6063());
                } else {
                    this.method_6033(this.method_6032() + 3.0f);
                }
                item.method_7934(1);
            } else if (item.method_31574(ItemRegistry.STRAW_HAT.get()) && !this.hasHat()) {
                this.field_6011.method_12778(HAT, (Object)true);
            }
            return class_1269.field_21466;
        }
        if (pHand == class_1268.field_5808 && pPlayer.method_6047().method_7960() && pPlayer.method_18276() && pPlayer instanceof GolemOrderer) {
            GolemOrderer orderer = (GolemOrderer)pPlayer;
            if (orderer.strawgolemRewrite$getGolem() == null || !orderer.strawgolemRewrite$getGolem().equals((Object)this)) {
                orderer.strawgolemRewrite$setGolem(this);
                pPlayer.method_7353((class_2561)class_2561.method_43471((String)"strawgolem.ordering.start"), true);
            } else {
                orderer.strawgolemRewrite$setGolem(null);
                pPlayer.method_7353((class_2561)class_2561.method_43471((String)"strawgolem.ordering.stop"), true);
            }
        }
        return super.method_5992(pPlayer, pHand);
    }

    protected void method_6074(class_1282 pDamageSource, float pDamageAmount) {
        if ((float)this.barrelHP() - pDamageAmount >= 0.0f) {
            this.field_6011.method_12778(BARREL, (Object)((int)((float)this.barrelHP() - pDamageAmount)));
            this.method_43077(class_3417.field_15150);
            return;
        }
        if (this.hasBarrel()) {
            pDamageAmount -= (float)this.barrelHP();
            this.field_6011.method_12778(BARREL, (Object)0);
            this.method_43077(class_3417.field_15239);
        }
        super.method_6074(pDamageSource, pDamageAmount);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.field_6011.method_12778(HAT, (Object)tag.method_10577("hat"));
        this.field_6011.method_12778(CARRY_STATUS, (Object)tag.method_10550("carry"));
        this.field_6011.method_12778(BARREL, (Object)tag.method_10550("barrelHP"));
        this.field_6011.method_12778(PRIORITY_POS, (Object)class_2338.method_10092((long)tag.method_10537("priorityPos")));
    }

    public void method_5652(class_2487 tag) {
        tag.method_10556("hat", this.hasHat());
        tag.method_10569("carry", this.carryStatus());
        tag.method_10569("barrelHP", this.barrelHP());
        tag.method_10544("priorityPos", ((class_2338)this.field_6011.method_12789(PRIORITY_POS)).method_10063());
        super.method_5652(tag);
    }

    public int healthStatus() {
        return this.method_6063() - 1.0E-4f <= this.method_6032() ? 0 : ((double)this.method_6063() * 0.333333 < (double)this.method_6032() ? 1 : 2);
    }

    public int movementStatus() {
        double movement = this.method_18798().method_37267() * (double)this.method_37908().method_54719().method_54748();
        return movement == 0.0 ? 0 : (movement < defaultWalkSpeed * 0.8 ? 1 : 2);
    }

    public int carryStatus() {
        return (Integer)this.field_6011.method_12789(CARRY_STATUS);
    }

    public void setCarryStatus(int status) {
        this.field_6011.method_12778(CARRY_STATUS, (Object)status);
    }

    public int pickupStatus() {
        return (Integer)this.field_6011.method_12789(PICKUP_STATUS);
    }

    public void setPickupStatus(int status) {
        this.field_6011.method_12778(PICKUP_STATUS, (Object)status);
    }

    public void setPickupStatus(class_1799 item) {
        if (!item.method_7960()) {
            if (item.method_7909() instanceof class_1747) {
                this.setPickupStatus(2);
            } else {
                this.setPickupStatus(1);
            }
        } else {
            this.setPickupStatus(0);
        }
    }

    public boolean isScared() {
        return false;
    }

    public boolean holdItemAbove() {
        return this.carryStatus() == 2 || this.hasBarrel();
    }

    public boolean hasHat() {
        return (Boolean)this.field_6011.method_12789(HAT);
    }

    public int barrelHP() {
        return (Integer)this.field_6011.method_12789(BARREL);
    }

    public boolean hasBarrel() {
        return this.barrelHP() != 0;
    }

    public void setPriorityPos(class_2338 pos) {
        this.field_6011.method_12778(PRIORITY_POS, (Object)pos);
    }

    public class_2338 getPriorityPos() {
        return (class_2338)this.field_6011.method_12789(PRIORITY_POS);
    }

    public boolean shouldForceAnimationReset() {
        if (this.forceAnimationReset) {
            this.forceAnimationReset = false;
            return true;
        }
        return false;
    }

    public void forceAnimationReset() {
        this.forceAnimationReset = true;
    }

    public class Deliverer {
        class_2338 storagePos;

        public class_2338 getDeliverable() {
            StrawGolem golem = StrawGolem.this;
            BiPredicate predicate = (gol, pos) -> VisionHelper.canSee((class_1297)gol, pos) && ContainerHelper.isContainer((class_1308)gol, pos) && ReachHelper.canPath((class_1308)gol, pos);
            if (StrawGolem.this.getPriorityPos().method_10263() != Integer.MAX_VALUE && predicate.filter(golem, StrawGolem.this.getPriorityPos())) {
                return StrawGolem.this.getPriorityPos();
            }
            if (this.storagePos != null && predicate.filter(golem, this.storagePos)) {
                return this.storagePos;
            }
            class_2338 pos2 = VisionHelper.findNearestBlock(golem, predicate);
            this.storagePos = this.storagePos == null || !predicate.filter(golem, this.storagePos) ? pos2 : this.storagePos;
            return pos2;
        }

        public void deliver(class_4538 level, class_2338 pos) {
            class_1799 item = StrawGolem.this.method_6047();
            if (!item.method_7960() && ContainerHelper.isContainer(level, pos)) {
                class_2586 class_25862 = level.method_8321(pos);
                if (class_25862 instanceof class_1263) {
                    class_1799 cItem;
                    int i;
                    class_1263 container = (class_1263)class_25862;
                    for (i = 0; i < container.method_5439(); ++i) {
                        cItem = container.method_5438(i);
                        if (!cItem.method_31574(item.method_7909()) || container.method_58350(cItem) <= cItem.method_7947()) continue;
                        cItem.method_7933(item.method_7947());
                        container.method_5447(i, cItem);
                        StrawGolem.this.method_5673(class_1304.field_6173, class_1799.field_8037);
                        return;
                    }
                    for (i = 0; i < container.method_5439(); ++i) {
                        cItem = container.method_5438(i);
                        if (!cItem.method_7960() || container.method_5444() <= cItem.method_7947()) continue;
                        container.method_5447(i, item);
                        StrawGolem.this.method_5673(class_1304.field_6173, class_1799.field_8037);
                        return;
                    }
                }
            } else {
                Constants.LOG.error("Delivery location is not a container! {} {}", (Object)item.method_7960(), (Object)ContainerHelper.isContainer(level, pos));
            }
        }
    }

    public class Harvester {
        Queue<class_2338> harvestLocations;

        public Harvester(StrawGolem this$0) {
        }

        class_2338 nextLocation() {
            return this.harvestLocations == null ? null : this.harvestLocations.poll();
        }
    }
}

