/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem.goals;

import java.util.Collections;
import java.util.Queue;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2195;
import net.minecraft.class_2246;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_8567;
import net.minecraft.class_9334;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.golem.StrawGolem;
import org.hero.strawgolem.golem.api.BiPredicate;
import org.hero.strawgolem.golem.api.ReachHelper;
import org.hero.strawgolem.golem.api.VisionHelper;
import org.hero.strawgolem.golem.goals.GolemMoveToBlockGoal;

public class GolemHarvestGoal
extends GolemMoveToBlockGoal {
    private StrawGolem golem;
    private Queue<class_2338> queue;
    private int harvestTimer = 0;
    private class_1799 item;
    private BiPredicate predicate = (gol, pos) -> this.isGrownPlant((class_4538)gol.method_37908(), pos) && ReachHelper.canPath((class_1308)gol, pos);

    public GolemHarvestGoal(StrawGolem golem) {
        super((class_1314)golem, Constants.Golem.defaultWalkSpeed, Constants.Golem.searchRange, 3);
        this.golem = golem;
    }

    @Override
    protected boolean method_6296(class_4538 levelReader, class_2338 blockPos) {
        return VisionHelper.canSee((class_1297)this.golem, blockPos) && this.predicate.filter(this.golem, blockPos);
    }

    public void method_6268() {
        try {
            super.method_6268();
            if (ReachHelper.canReach((class_1308)this.field_6516, this.field_6512) && this.item == null) {
                this.item = this.harvest();
                this.golem.setPickupStatus(this.item);
                this.golem.method_5942().method_6340();
            } else if (this.item != null && !this.item.method_7960()) {
                ++this.harvestTimer;
                if (this.harvestTimer == 20 && this.predicate.filter(this.golem, this.field_6512) && ReachHelper.canReach((class_1308)this.field_6516, this.field_6512)) {
                    this.item = this.harvest();
                    this.blockReset(this.golem.method_37908());
                    this.golem.method_5673(class_1304.field_6173, this.item);
                } else if (this.harvestTimer == 40) {
                    this.golem.setPickupStatus(0);
                } else if (this.harvestTimer < 20 && !this.predicate.filter(this.golem, this.field_6512)) {
                    this.golem.forceAnimationReset();
                    this.golem.setPickupStatus(0);
                    this.item = null;
                }
            } else if (this.method_6294() && this.golemCollision(this.golem)) {
                this.nudge(this.golem);
            }
        }
        catch (Exception e) {
            Constants.LOG.error(e.getMessage());
            this.method_6270();
        }
    }

    public void method_6269() {
        if (this.field_6512 == null) {
            this.field_6512 = this.queue.poll();
        }
        this.method_6290();
        this.field_6517 = 0;
        this.harvestTimer = 0;
        this.item = null;
    }

    public void method_6270() {
        this.golem.setPickupStatus(0);
    }

    protected void method_6290() {
        this.field_6516.method_5942().method_58160((double)this.field_6512.method_10263() + 0.5, (double)this.field_6512.method_10264(), (double)this.field_6512.method_10260() + 0.5, 0, this.field_6514);
    }

    public boolean method_6264() {
        if (this.golem.method_6047().method_7960() && this.queue == null) {
            this.queue = VisionHelper.nearbyBlocks(this.golem, this.predicate);
        } else if (this.queue != null && this.queue.isEmpty()) {
            this.queue = VisionHelper.nearbyBlocks(this.golem, this.predicate);
        }
        if (this.queue == null || this.queue.isEmpty()) {
            return false;
        }
        do {
            this.field_6512 = this.queue.poll();
        } while (!this.predicate.filter(this.golem, this.field_6512) && !this.queue.isEmpty());
        return this.golem.method_6047().method_7960() && this.method_6296((class_4538)this.golem.method_37908(), this.field_6512);
    }

    public boolean method_6266() {
        return this.harvestTimer <= 38 && (this.golem.method_6047().method_7960() || this.harvestTimer <= 40) && this.method_6296((class_4538)this.golem.method_37908(), this.field_6512);
    }

    private boolean isPlant(class_4538 levelReader, class_2338 blockPos) {
        return levelReader != null && blockPos != null && levelReader.method_8320(blockPos).method_26204() instanceof class_2302;
    }

    private boolean isGrownPlant(class_4538 levelReader, class_2338 blockPos) {
        if (levelReader == null || blockPos == null) {
            return false;
        }
        class_2680 state = levelReader.method_8320(blockPos);
        Object object = state.method_26204();
        if (object instanceof class_2302) {
            class_2302 crop = (class_2302)object;
            return crop.method_9825(state);
        }
        object = state.method_26204();
        if (object instanceof class_2261) {
            class_2261 bush = (class_2261)object;
            for (class_2769 prop : state.method_28501()) {
                if (!(prop instanceof class_2758)) continue;
                class_2758 intProp = (class_2758)prop;
                if (!prop.method_11899().equals("age") || (Integer)state.method_11654((class_2769)intProp) < (Integer)Collections.max(intProp.method_11898())) continue;
                return true;
            }
        } else if (Constants.Golem.blockHarvest && state.method_26204() == class_2246.field_46282 || state.method_26204() == class_2246.field_46283) {
            try {
                for (class_2350 dir : class_2350.values()) {
                    if (!(levelReader.method_8320(blockPos.method_10093(dir)).method_26204() instanceof class_2195) || !state.method_28498((class_2769)class_2195.field_9873) || !blockPos.method_10093(dir).method_10093((class_2350)state.method_11654((class_2769)class_2195.field_9873)).equals((Object)blockPos)) continue;
                    return true;
                }
            }
            catch (Throwable e) {
                Constants.LOG.error(e.getMessage());
                return false;
            }
        }
        return false;
    }

    public class_1799 harvest() {
        class_1937 class_19372 = this.golem.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            class_2680 state = level.method_8320(this.field_6512);
            class_8567.class_8568 builder = new class_8567.class_8568(level).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51874(class_181.field_24424, (Object)this.field_6516.method_19538());
            class_1799 drops = state.method_26189(builder).stream().filter(this::isCropDrop).findFirst().orElse(class_1799.field_8037);
            return drops;
        }
        Constants.LOG.error("Golem level not ServerLevel!");
        return class_1799.field_8037;
    }

    private void blockReset(class_1937 level) {
        class_2680 state = level.method_8320(this.field_6512);
        for (class_2769 prop : state.method_28501()) {
            if (!prop.method_11899().equalsIgnoreCase("age") || !(prop instanceof class_2758)) continue;
            class_2758 intprop = (class_2758)prop;
            int value = (Integer)state.method_26204().method_9564().method_11654((class_2769)intprop);
            level.method_45447(null, this.field_6512, state.method_26231().method_10595(), class_3419.field_15245);
            state = (class_2680)state.method_11657((class_2769)intprop, (Comparable)Integer.valueOf(value));
            level.method_8501(this.field_6512, state);
        }
    }

    private boolean isCropDrop(class_1799 item) {
        return !(item.method_7909() instanceof class_1798) || item.method_7909().method_57347().method_57832(class_9334.field_50075);
    }
}

