/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.config;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;

public enum KeepInventoryAction {
    KEEP(event -> {
        event.getDrops().clear();
        event.setKeepInventory(true);
    }),
    DROP(event -> event.setKeepInventory(false)),
    DESTROY(event -> {
        event.getDrops().clear();
        event.setKeepInventory(false);
    });

    @NotNull
    public final Consumer<PlayerDeathEvent> consumer;

    private KeepInventoryAction(Consumer<PlayerDeathEvent> consumer) {
        this.consumer = consumer;
    }

    @NotNull
    public static Optional<KeepInventoryAction> fromString(@Nullable String string) {
        if (string != null) {
            try {
                return Optional.of(KeepInventoryAction.valueOf(string.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                AnnoyingPlugin.log(Level.WARNING, "Invalid value in keep-inventory.actions: " + string);
            }
        }
        return Optional.empty();
    }
}

