/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.LimitedLives;
import xyz.srnyx.limitedlives.config.GracePeriodTrigger;
import xyz.srnyx.limitedlives.config.KeepInventoryAction;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.data.ItemData;
import xyz.srnyx.limitedlives.libs.annoyingapi.file.AnnoyingResource;

public class LimitedConfig {
    @NotNull
    private final AnnoyingResource config;
    @NotNull
    public final Lives lives;
    @NotNull
    public final Set<String> deathCauses;
    @NotNull
    public final KeepInventory keepInventory;
    @NotNull
    public final GracePeriod gracePeriod;
    @NotNull
    public final Commands commands;
    @NotNull
    public final Obtaining obtaining;
    @NotNull
    public final WorldsBlacklist worldsBlacklist;

    public LimitedConfig(@NotNull LimitedLives plugin) {
        this.config = new AnnoyingResource((AnnoyingPlugin)plugin, "config.yml");
        this.lives = new Lives();
        this.deathCauses = LimitedConfig.getDamageCauses(this.config.getStringList("death-causes"));
        this.keepInventory = new KeepInventory();
        this.gracePeriod = new GracePeriod();
        this.commands = new Commands();
        this.obtaining = new Obtaining();
        this.worldsBlacklist = new WorldsBlacklist();
    }

    @NotNull
    private static Set<String> getDamageCauses(@NotNull List<String> collection) {
        return collection.stream().map(String::toUpperCase).collect(Collectors.toSet());
    }

    public class WorldsBlacklist {
        @NotNull
        public final Set<String> list;
        public final boolean actAsWhitelist;

        public WorldsBlacklist() {
            this.list = LimitedConfig.this.config.getStringList("worlds-blacklist.list").stream().map(String::toLowerCase).collect(Collectors.toSet());
            this.actAsWhitelist = LimitedConfig.this.config.getBoolean("worlds-blacklist.act-as-whitelist", false);
        }

        public boolean isWorldEnabled(@NotNull World world) {
            return this.actAsWhitelist == this.list.contains(world.getName().toLowerCase());
        }
    }

    public class Obtaining {
        public final boolean stealing;
        @NotNull
        public final Crafting crafting;

        public Obtaining() {
            this.stealing = LimitedConfig.this.config.getBoolean("obtaining.stealing", true);
            this.crafting = new Crafting();
        }

        public class Crafting {
            public final int amount;
            @Nullable
            public final Recipe recipe;

            public Crafting() {
                this.amount = LimitedConfig.this.config.getInt("obtaining.crafting.amount", 1);
                this.recipe = LimitedConfig.this.config.getBoolean("obtaining.crafting.enabled", true) ? (Recipe)LimitedConfig.this.config.getRecipe("obtaining.crafting.recipe", item -> (ItemStack)new ItemData((AnnoyingPlugin)((LimitedConfig)LimitedConfig.this).config.plugin, (ItemStack)item).setChain((String)"ll_item", (Object)Boolean.valueOf((boolean)true)).target, "life").orElse(null) : null;
            }
        }
    }

    public class Commands {
        @NotNull
        public final Punishment punishment = new Punishment();
        @NotNull
        public final List<String> revive = LimitedConfig.access$000(LimitedConfig.this).getStringList("commands.revive");

        public class Punishment {
            @NotNull
            public final List<String> death;
            @NotNull
            public final List<String> respawn;

            public Punishment() {
                this.death = LimitedConfig.this.config.getStringList("commands.punishment.death");
                this.respawn = LimitedConfig.this.config.getStringList("commands.punishment.respawn");
            }
        }
    }

    public class GracePeriod {
        public final boolean enabled;
        public final int duration;
        @NotNull
        public final Set<GracePeriodTrigger> triggers;
        @NotNull
        public final Set<String> bypassCauses;
        @NotNull
        public final Set<String> disabledDamageCauses;

        public GracePeriod() {
            this.enabled = LimitedConfig.this.config.getBoolean("grace-period.enabled", false);
            this.duration = LimitedConfig.this.config.getInt("grace-period.duration", 60) * 1000;
            this.triggers = LimitedConfig.this.config.getStringList("grace-period.triggers").stream().map(GracePeriodTrigger::fromString).filter(Objects::nonNull).collect(Collectors.toSet());
            this.bypassCauses = LimitedConfig.getDamageCauses(LimitedConfig.this.config.getStringList("grace-period.bypass-causes"));
            this.disabledDamageCauses = LimitedConfig.getDamageCauses(LimitedConfig.this.config.getStringList("grace-period.disabled-damage-causes"));
        }
    }

    public class KeepInventory {
        public final boolean enabled;
        @NotNull
        public final Actions actions;

        public KeepInventory() {
            this.enabled = LimitedConfig.this.config.getBoolean("keep-inventory.enabled", false);
            this.actions = new Actions();
            if (this.enabled) {
                Bukkit.getWorlds().stream().filter(world -> world.getGameRuleValue("keepInventory").equals("true")).forEach(world -> {
                    AnnoyingPlugin.log(Level.WARNING, "keepInventory is enabled in " + world.getName() + "! The plugin is disabling it to ensure the keep-inventory feature works properly");
                    world.setGameRuleValue("keepInventory", "false");
                });
            }
        }

        public class Actions {
            @NotNull
            private final KeepInventoryAction def;
            @NotNull
            private final Map<Integer, KeepInventoryAction> exact = new HashMap<Integer, KeepInventoryAction>();

            public Actions() {
                this.def = KeepInventoryAction.fromString(LimitedConfig.this.config.getString("keep-inventory.actions.default")).orElse(KeepInventoryAction.KEEP);
                ConfigurationSection section = LimitedConfig.this.config.getConfigurationSection("keep-inventory.actions");
                if (section != null) {
                    for (String key : section.getKeys(false)) {
                        int count;
                        if (key.equals("default") || key.equals("first") || key.equals("last")) continue;
                        try {
                            count = Integer.parseInt(key);
                        }
                        catch (NumberFormatException e) {
                            AnnoyingPlugin.log(Level.WARNING, "Invalid keep inventory action count: " + key);
                            continue;
                        }
                        KeepInventoryAction.fromString(LimitedConfig.this.config.getString("keep-inventory.actions." + key)).ifPresent(keepInventoryAction -> this.exact.put(count, (KeepInventoryAction)((Object)keepInventoryAction)));
                    }
                }
            }

            @NotNull
            public KeepInventoryAction getAction(int deaths) {
                KeepInventoryAction action = this.exact.get(deaths);
                return action != null ? action : this.def;
            }
        }
    }

    public class Lives {
        public final int def;
        public final int max;
        public final int min;

        public Lives() {
            this.def = LimitedConfig.this.config.getInt("lives.default", 5);
            this.max = LimitedConfig.this.config.getInt("lives.max", 10);
            this.min = LimitedConfig.this.config.getInt("lives.min", 0);
        }
    }
}

