/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.library;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.library.AnnoyingLibrary;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.libby.BukkitLibraryManager;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.libby.classloader.IsolatedClassLoader;
import xyz.srnyx.limitedlives.libs.annoyingapi.parents.Annoyable;

public class AnnoyingLibraryManager
extends BukkitLibraryManager
implements Annoyable {
    @NotNull
    private final AnnoyingPlugin plugin;
    @NotNull
    private final Set<AnnoyingLibrary> loadedLibraries = new HashSet<AnnoyingLibrary>();

    public AnnoyingLibraryManager(@NotNull AnnoyingPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
    }

    public AnnoyingLibraryManager(@NotNull AnnoyingPlugin plugin, @NotNull String directoryName) {
        super((Plugin)plugin, directoryName);
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public AnnoyingPlugin getAnnoyingPlugin() {
        return this.plugin;
    }

    public void loadLibrary(@NotNull AnnoyingLibrary library) {
        this.loadLibrary(library.getLibraryWithRelocations(this.plugin).build());
        this.loadedLibraries.add(library);
    }

    @NotNull
    public IsolatedClassLoader loadLibraryIsolated(@NotNull AnnoyingLibrary library) {
        this.loadLibrary(library.getLibrary().isolatedLoad(true).build());
        return this.getIsolatedClassLoaderOf(library).orElseThrow(() -> new IllegalStateException("Failed to load isolated library"));
    }

    @NotNull
    public Optional<IsolatedClassLoader> getIsolatedClassLoaderOf(@NotNull AnnoyingLibrary library) {
        return Optional.ofNullable(this.getIsolatedClassLoaderOf(library.getId()));
    }

    public boolean isLoaded(@NotNull AnnoyingLibrary library) {
        return this.loadedLibraries.contains(library);
    }

    public boolean isLoadedIsolated(@NotNull AnnoyingLibrary library) {
        return this.getIsolatedClassLoaderOf(library).isPresent();
    }
}

