/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FileUtility {
    public static boolean deleteFile(@NotNull Path path, boolean silentFail) {
        try {
            Files.delete(path);
            return true;
        }
        catch (IOException e) {
            if (!silentFail) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @NotNull
    public static Set<String> getFileNames(@NotNull File file, @NotNull String extension) {
        File[] files = file.listFiles();
        if (files == null) {
            return Collections.emptySet();
        }
        String fullExtension = "." + extension;
        int extensionLength = fullExtension.length();
        return Arrays.stream(files).map(File::getName).filter(name -> name.endsWith(fullExtension)).map(name -> name.substring(0, name.length() - extensionLength)).collect(Collectors.toSet());
    }

    private FileUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

