/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpUtility {
    public static boolean DEBUG = false;

    @NotNull
    public static <T> Optional<T> get(@NotNull String userAgent, @NotNull String url, @NotNull Function<InputStreamReader, T> function, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        Object result;
        block6: {
            result = null;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(url).toURL().openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", userAgent);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                if (connection.getResponseCode() == 404) {
                    if (DEBUG) {
                        System.out.println("[JU] 404: " + url);
                    }
                    return Optional.empty();
                }
                result = function.apply(new InputStreamReader(connection.getInputStream()));
            }
            catch (Exception e) {
                if (!DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return Optional.ofNullable(result);
    }

    @NotNull
    public static Optional<String> getString(@NotNull String userAgent, @NotNull String urlString, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        return HttpUtility.get(userAgent, urlString, reader -> new BufferedReader((Reader)reader).lines().collect(Collectors.joining("\n")), connectionConsumer);
    }

    @NotNull
    public static Optional<JsonElement> getJson(@NotNull String userAgent, @NotNull String urlString, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        return HttpUtility.get(userAgent, urlString, reader -> new JsonParser().parse((Reader)reader), connectionConsumer);
    }

    @Nullable
    public static Response postJson(@NotNull String userAgent, @NotNull String urlString, @Nullable JsonElement data, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        Response response;
        block5: {
            response = null;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("User-Agent", userAgent);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                if (data != null) {
                    connection.getOutputStream().write(data.toString().getBytes());
                }
                response = new Response(connection.getResponseCode(), connection.getResponseMessage());
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return response;
    }

    @Nullable
    public static Response putJson(@NotNull String userAgent, @NotNull String urlString, @Nullable JsonElement data, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        Response response;
        block5: {
            response = null;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
                connection.setRequestMethod("PUT");
                connection.setRequestProperty("User-Agent", userAgent);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                if (data != null) {
                    connection.getOutputStream().write(data.toString().getBytes());
                }
                response = new Response(connection.getResponseCode(), connection.getResponseMessage());
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return response;
    }

    @Nullable
    public static Response delete(@NotNull String userAgent, @NotNull String urlString, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        Response response;
        block4: {
            response = null;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
                connection.setRequestMethod("DELETE");
                connection.setRequestProperty("User-Agent", userAgent);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                response = new Response(connection.getResponseCode(), connection.getResponseMessage());
            }
            catch (Exception e) {
                if (!DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return response;
    }

    private HttpUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Response {
        public final int code;
        @Nullable
        public final String message;

        public Response(int code, @Nullable String message) {
            this.code = code;
            this.message = message;
        }
    }
}

