/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.manipulation;

import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.MiscUtility;

public class Mapper {
    @NotNull
    public static <T> Optional<T> to(@Nullable Object object, @NotNull Class<T> clazz) {
        return !clazz.isInstance(object) ? Optional.empty() : MiscUtility.handleException(() -> clazz.cast(object), ClassCastException.class);
    }

    @NotNull
    public static Optional<Integer> toInt(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> Integer.parseInt(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<Double> toDouble(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> Double.parseDouble(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<Long> toLong(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> Long.parseLong(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<UUID> toUUID(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> UUID.fromString(object.toString()), IllegalArgumentException.class);
    }

    @NotNull
    public static <T extends Enum<T>> Optional<T> toEnum(@Nullable String name, @NotNull Class<T> enumClass) {
        return name == null || name.isEmpty() ? Optional.empty() : MiscUtility.handleException(() -> Enum.valueOf(enumClass, name.toUpperCase()), IllegalArgumentException.class);
    }

    private Mapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

