/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.utility;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;

public class ReflectionUtility {
    @Nullable
    public static Class<?> getClass(int major, int minor, int patch, @NotNull String className) {
        if (ReflectionUtility.checkVersion(major, minor, patch)) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static Class<?> getClass(int major, int minor, int patch, @NotNull Class<?> reflectionClass) {
        String className = ReflectionUtility.getClassName(reflectionClass);
        return className == null ? null : ReflectionUtility.getClass(major, minor, patch, className);
    }

    @Nullable
    public static Class<? extends Enum> getEnum(int major, int minor, int patch, @NotNull String enumClassName) {
        if (ReflectionUtility.checkVersion(major, minor, patch)) {
            try {
                return Class.forName(enumClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static Class<? extends Enum> getEnum(int major, int minor, int patch, @NotNull Class<?> reflectionClass) {
        String enumClassName = ReflectionUtility.getClassName(reflectionClass);
        return enumClassName == null ? null : ReflectionUtility.getEnum(major, minor, patch, enumClassName);
    }

    @Nullable
    public static Class<?> getClassArray(int major, int minor, int patch, @NotNull String className) {
        if (ReflectionUtility.checkVersion(major, minor, patch)) {
            try {
                return Class.forName("[L" + className + ";");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static Class<?> getClassArray(int major, int minor, int patch, @NotNull Class<?> reflectionClass) {
        String className = ReflectionUtility.getClassName(reflectionClass);
        return className == null ? null : ReflectionUtility.getClassArray(major, minor, patch, className);
    }

    @Nullable
    public static <T> Constructor<T> getConstructor(int major, int minor, int patch, @Nullable Class<T> clazz, Class<?> ... parameterTypes) {
        if (clazz != null && parameterTypes != null && ReflectionUtility.checkVersion(major, minor, patch)) {
            try {
                return clazz.getConstructor(parameterTypes);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static <T> Method getMethod(int major, int minor, int patch, @Nullable Class<T> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        if (clazz != null && parameterTypes != null && ReflectionUtility.checkVersion(major, minor, patch)) {
            try {
                return clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static Field getField(int major, int minor, int patch, @Nullable Class<?> clazz, @NotNull String fieldName) {
        if (clazz != null && ReflectionUtility.checkVersion(major, minor, patch)) {
            try {
                return clazz.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static Field getDeclaredField(int major, int minor, int patch, @Nullable Class<?> clazz, @NotNull String fieldName) {
        if (clazz != null && ReflectionUtility.checkVersion(major, minor, patch)) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static Object getStaticFieldValue(int major, int minor, int patch, @Nullable Class<?> clazz, @NotNull String fieldName) {
        Field field = ReflectionUtility.getField(major, minor, patch, clazz, fieldName);
        if (field != null) {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static <T extends Enum> T getEnumValue(int major, int minor, int patch, @Nullable Class<T> enumClass, @NotNull String enumName) throws IllegalArgumentException {
        return enumClass != null && ReflectionUtility.checkVersion(major, minor, patch) ? (T)Enum.valueOf(enumClass, enumName) : null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static Object createArray(@Nullable Class<?> clazz, @Range(from=0L, to=0x7FFFFFFFL) int length) {
        return clazz == null || clazz == Void.TYPE ? null : Array.newInstance(clazz, length);
    }

    private static boolean checkVersion(int major, int minor, int patch) {
        return AnnoyingPlugin.MINECRAFT_VERSION.isGreaterThanOrEqualTo(major, minor, patch);
    }

    @Nullable
    private static String getClassName(@NotNull Class<?> reflectedClass) {
        String[] split = reflectedClass.getName().split("\\.reflection\\.", 2);
        return split.length == 1 ? null : split[1].replace("Ref", "");
    }

    private ReflectionUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

