/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.listeners;

import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.limitedlives.LimitedLives;
import xyz.srnyx.limitedlives.config.GracePeriodTrigger;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingListener;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.data.EntityData;
import xyz.srnyx.limitedlives.libs.annoyingapi.data.ItemData;
import xyz.srnyx.limitedlives.libs.annoyingapi.message.AnnoyingMessage;
import xyz.srnyx.limitedlives.libs.annoyingapi.message.DefaultReplaceType;
import xyz.srnyx.limitedlives.managers.player.PlayerManager;
import xyz.srnyx.limitedlives.managers.player.exception.ActionException;
import xyz.srnyx.limitedlives.managers.player.exception.LessThanMinLives;
import xyz.srnyx.limitedlives.managers.player.exception.MoreThanMaxLives;

public class PlayerListener
extends AnnoyingListener {
    @NotNull
    private final LimitedLives plugin;

    public PlayerListener(@NotNull LimitedLives plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public LimitedLives getAnnoyingPlugin() {
        return this.plugin;
    }

    @EventHandler
    public void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        long graceLeft;
        Player player = event.getEntity();
        if (!this.plugin.config.worldsBlacklist.isWorldEnabled(player.getWorld())) {
            return;
        }
        Player killer = player.getKiller();
        boolean isPvp = killer != null && killer != player;
        String cause = "PLAYER_ATTACK";
        if (!isPvp) {
            EntityDamageEvent damageEvent = player.getLastDamageCause();
            String string = cause = damageEvent != null ? damageEvent.getCause().name() : null;
        }
        if (cause != null && !this.plugin.config.deathCauses.isEmpty() && !this.plugin.config.deathCauses.contains(cause)) {
            return;
        }
        if (this.plugin.worldGuard != null && !this.plugin.worldGuard.test(player)) {
            return;
        }
        PlayerManager manager = new PlayerManager(this.plugin, (OfflinePlayer)player);
        if (!(cause != null && this.plugin.config.gracePeriod.bypassCauses.contains(cause) || (graceLeft = manager.getGraceLeft()) <= 0L)) {
            new AnnoyingMessage(this.plugin, "lives.grace").replace("%remaining%", graceLeft, DefaultReplaceType.TIME).send((CommandSender)player);
            return;
        }
        try {
            int newLives = manager.removeLives(1, killer);
            if (newLives <= this.plugin.config.lives.min) {
                new AnnoyingMessage(this.plugin, "lives.zero").send((CommandSender)player);
            } else if (isPvp) {
                new AnnoyingMessage(this.plugin, "lives.lose.player").replace("%killer%", killer.getName()).replace("%lives%", newLives).send((CommandSender)player);
            } else {
                new AnnoyingMessage(this.plugin, "lives.lose.other").replace("%lives%", newLives).send((CommandSender)player);
            }
        }
        catch (LessThanMinLives e) {
            new AnnoyingMessage(this.plugin, "lives.zero").send((CommandSender)player);
        }
        if (this.plugin.config.keepInventory.enabled) {
            this.plugin.config.keepInventory.actions.getAction((int)manager.getDeaths()).consumer.accept(event);
        }
        if (this.plugin.config.obtaining.stealing && isPvp) {
            try {
                new AnnoyingMessage(this.plugin, "lives.steal").replace("%target%", player.getName()).replace("%lives%", new PlayerManager(this.plugin, (OfflinePlayer)killer).addLives(1)).send((CommandSender)killer);
            }
            catch (ActionException actionException) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onPlayerRespawn(@NotNull PlayerRespawnEvent event) {
        final Player player = event.getPlayer();
        EntityData data = new EntityData((AnnoyingPlugin)this.plugin, (Entity)player);
        String killerString = data.get("ll_dead");
        if (killerString == null) {
            return;
        }
        data.remove("ll_dead");
        OfflinePlayer killer = null;
        if (!killerString.equals("null")) {
            try {
                killer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(killerString));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        final OfflinePlayer finalKiller = killer;
        new BukkitRunnable(){

            public void run() {
                PlayerManager.dispatchCommands(((PlayerListener)PlayerListener.this).plugin.config.commands.punishment.respawn, (OfflinePlayer)player, finalKiller);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event) {
        String cause;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        String string = cause = event.getDamager() instanceof Player ? "PLAYER_ATTACK" : event.getCause().name();
        if (this.plugin.config.gracePeriod.disabledDamageCauses.contains(cause) && new PlayerManager(this.plugin, (OfflinePlayer)((Player)entity)).hasGrace()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerItemConsume(@NotNull PlayerItemConsumeEvent event) {
        if (this.plugin.config.obtaining.crafting.recipe == null || !new ItemData((AnnoyingPlugin)this.plugin, event.getItem()).has("ll_item")) {
            return;
        }
        Player player = event.getPlayer();
        try {
            new AnnoyingMessage(this.plugin, "eat.success").replace("%lives%", new PlayerManager(this.plugin, (OfflinePlayer)player).addLives(this.plugin.config.obtaining.crafting.amount)).send((CommandSender)player);
        }
        catch (MoreThanMaxLives e) {
            event.setCancelled(true);
            new AnnoyingMessage(this.plugin, "eat.max").replace("%max%", this.plugin.config.lives.max).send((CommandSender)player);
        }
    }

    @EventHandler
    public void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        EntityData data = new EntityData((AnnoyingPlugin)this.plugin, (Entity)player);
        Map<String, String> failed = data.convertOldData(true, "ll_lives", "ll_dead");
        if (failed == null) {
            AnnoyingPlugin.log(Level.SEVERE, "Failed to convert old data for player " + player.getName());
        } else if (!failed.isEmpty()) {
            AnnoyingPlugin.log(Level.WARNING, "Failed to convert some old data for player " + player.getName() + ": " + failed);
        }
        if (this.plugin.config.gracePeriod.enabled && (this.plugin.config.gracePeriod.triggers.contains((Object)GracePeriodTrigger.JOIN) || this.plugin.config.gracePeriod.triggers.contains((Object)GracePeriodTrigger.FIRST_JOIN) && !player.hasPlayedBefore())) {
            data.set("grace_start", System.currentTimeMillis());
        }
    }
}

